/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.fluent;

import backtype.storm.tuple.Fields;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import storm.trident.Stream;
import storm.trident.fluent.ChainedFullAggregatorDeclarer;
import storm.trident.fluent.ChainedPartitionAggregatorDeclarer;
import storm.trident.fluent.GlobalAggregationScheme;
import storm.trident.fluent.IAggregatableStream;
import storm.trident.operation.Aggregator;
import storm.trident.operation.CombinerAggregator;
import storm.trident.operation.ReducerAggregator;
import storm.trident.operation.impl.ChainedAggregatorImpl;
import storm.trident.operation.impl.ChainedResult;
import storm.trident.operation.impl.CombinerAggregatorCombineImpl;
import storm.trident.operation.impl.CombinerAggregatorInitImpl;
import storm.trident.operation.impl.ReducerAggregatorImpl;
import storm.trident.operation.impl.SingleEmitAggregator;
import storm.trident.tuple.ComboList;

public class ChainedAggregatorDeclarer
implements ChainedFullAggregatorDeclarer,
ChainedPartitionAggregatorDeclarer {
    List<AggSpec> _aggs = new ArrayList<AggSpec>();
    IAggregatableStream _stream;
    AggType _type = null;
    GlobalAggregationScheme _globalScheme;

    public ChainedAggregatorDeclarer(IAggregatableStream stream, GlobalAggregationScheme globalScheme) {
        this._stream = stream;
        this._globalScheme = globalScheme;
    }

    @Override
    public Stream chainEnd() {
        Fields[] inputFields = new Fields[this._aggs.size()];
        Aggregator[] aggs = new Aggregator[this._aggs.size()];
        int[] outSizes = new int[this._aggs.size()];
        ArrayList<String> allOutFields = new ArrayList<String>();
        HashSet<String> allInFields = new HashSet<String>();
        for (int i = 0; i < this._aggs.size(); ++i) {
            Fields outfields;
            AggSpec spec = this._aggs.get(i);
            Fields infields = spec.inFields;
            if (infields == null) {
                infields = new Fields(new String[0]);
            }
            if ((outfields = spec.outFields) == null) {
                outfields = new Fields(new String[0]);
            }
            inputFields[i] = infields;
            aggs[i] = spec.agg;
            outSizes[i] = outfields.size();
            allOutFields.addAll(outfields.toList());
            allInFields.addAll(infields.toList());
        }
        if (new HashSet(allOutFields).size() != allOutFields.size()) {
            throw new IllegalArgumentException("Output fields for chained aggregators must be distinct: " + ((Object)allOutFields).toString());
        }
        Fields inFields = new Fields(new ArrayList<String>(allInFields));
        Fields outFields = new Fields(allOutFields);
        ChainedAggregatorImpl combined = new ChainedAggregatorImpl(aggs, inputFields, new ComboList.Factory(outSizes));
        if (this._type != AggType.FULL) {
            this._stream = this._stream.partitionAggregate(inFields, combined, outFields);
        }
        if (this._type != AggType.PARTITION) {
            this._stream = this._globalScheme.aggPartition(this._stream);
            SingleEmitAggregator.BatchToPartition singleEmit = this._globalScheme.singleEmitPartitioner();
            Aggregator<ChainedResult> toAgg = combined;
            if (singleEmit != null) {
                toAgg = new SingleEmitAggregator(combined, singleEmit);
            }
            this._stream = this._stream.partitionAggregate(inFields, toAgg, outFields);
        }
        return this._stream.toStream();
    }

    @Override
    public ChainedPartitionAggregatorDeclarer partitionAggregate(Aggregator agg, Fields functionFields) {
        return this.partitionAggregate(null, agg, functionFields);
    }

    @Override
    public ChainedPartitionAggregatorDeclarer partitionAggregate(Fields inputFields, Aggregator agg, Fields functionFields) {
        this._type = AggType.PARTITION;
        this._aggs.add(new AggSpec(inputFields, agg, functionFields));
        return this;
    }

    @Override
    public ChainedPartitionAggregatorDeclarer partitionAggregate(CombinerAggregator agg, Fields functionFields) {
        return this.partitionAggregate(null, agg, functionFields);
    }

    @Override
    public ChainedPartitionAggregatorDeclarer partitionAggregate(Fields inputFields, CombinerAggregator agg, Fields functionFields) {
        this.initCombiner(inputFields, agg, functionFields);
        return this.partitionAggregate(functionFields, new CombinerAggregatorCombineImpl(agg), functionFields);
    }

    @Override
    public ChainedPartitionAggregatorDeclarer partitionAggregate(ReducerAggregator agg, Fields functionFields) {
        return this.partitionAggregate(null, agg, functionFields);
    }

    @Override
    public ChainedPartitionAggregatorDeclarer partitionAggregate(Fields inputFields, ReducerAggregator agg, Fields functionFields) {
        return this.partitionAggregate(inputFields, new ReducerAggregatorImpl(agg), functionFields);
    }

    @Override
    public ChainedFullAggregatorDeclarer aggregate(Aggregator agg, Fields functionFields) {
        return this.aggregate(null, agg, functionFields);
    }

    @Override
    public ChainedFullAggregatorDeclarer aggregate(Fields inputFields, Aggregator agg, Fields functionFields) {
        return this.aggregate(inputFields, agg, functionFields, false);
    }

    private ChainedFullAggregatorDeclarer aggregate(Fields inputFields, Aggregator agg, Fields functionFields, boolean isCombiner) {
        if (isCombiner) {
            if (this._type == null) {
                this._type = AggType.FULL_COMBINE;
            }
        } else {
            this._type = AggType.FULL;
        }
        this._aggs.add(new AggSpec(inputFields, agg, functionFields));
        return this;
    }

    @Override
    public ChainedFullAggregatorDeclarer aggregate(CombinerAggregator agg, Fields functionFields) {
        return this.aggregate(null, agg, functionFields);
    }

    @Override
    public ChainedFullAggregatorDeclarer aggregate(Fields inputFields, CombinerAggregator agg, Fields functionFields) {
        this.initCombiner(inputFields, agg, functionFields);
        return this.aggregate(functionFields, new CombinerAggregatorCombineImpl(agg), functionFields, true);
    }

    @Override
    public ChainedFullAggregatorDeclarer aggregate(ReducerAggregator agg, Fields functionFields) {
        return this.aggregate(null, agg, functionFields);
    }

    @Override
    public ChainedFullAggregatorDeclarer aggregate(Fields inputFields, ReducerAggregator agg, Fields functionFields) {
        return this.aggregate(inputFields, new ReducerAggregatorImpl(agg), functionFields);
    }

    private void initCombiner(Fields inputFields, CombinerAggregator agg, Fields functionFields) {
        this._stream = this._stream.each(inputFields, new CombinerAggregatorInitImpl(agg), functionFields);
    }

    private static class AggSpec {
        Fields inFields;
        Aggregator agg;
        Fields outFields;

        public AggSpec(Fields inFields, Aggregator agg, Fields outFields) {
            this.inFields = inFields;
            this.agg = agg;
            this.outFields = outFields;
        }
    }

    private static enum AggType {
        PARTITION,
        FULL,
        FULL_COMBINE;

    }

    public static interface AggregationPartition {
        public Stream partition(Stream var1);
    }
}

