/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.operation.impl;

import backtype.storm.tuple.Fields;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import storm.trident.operation.Aggregator;
import storm.trident.operation.TridentCollector;
import storm.trident.operation.TridentOperationContext;
import storm.trident.operation.impl.GroupCollector;
import storm.trident.tuple.ComboList;
import storm.trident.tuple.TridentTuple;
import storm.trident.tuple.TridentTupleView;

public class GroupedAggregator
implements Aggregator<Object[]> {
    TridentTupleView.ProjectionFactory _groupFactory;
    TridentTupleView.ProjectionFactory _inputFactory;
    Aggregator _agg;
    ComboList.Factory _fact;
    Fields _inFields;
    Fields _groupFields;

    public GroupedAggregator(Aggregator agg, Fields group, Fields input, int outSize) {
        this._groupFields = group;
        this._inFields = input;
        this._agg = agg;
        int[] sizes = new int[]{this._groupFields.size(), outSize};
        this._fact = new ComboList.Factory(sizes);
    }

    @Override
    public void prepare(Map conf, TridentOperationContext context) {
        this._inputFactory = context.makeProjectionFactory(this._inFields);
        this._groupFactory = context.makeProjectionFactory(this._groupFields);
        this._agg.prepare(conf, new TridentOperationContext(context, (TridentTuple.Factory)this._inputFactory));
    }

    @Override
    public Object[] init(Object batchId, TridentCollector collector) {
        return new Object[]{new GroupCollector(collector, this._fact), new HashMap(), batchId};
    }

    @Override
    public void aggregate(Object[] arr, TridentTuple tuple, TridentCollector collector) {
        Object curr;
        GroupCollector groupColl = (GroupCollector)arr[0];
        Map val = (Map)arr[1];
        TridentTuple group = this._groupFactory.create((TridentTupleView)tuple);
        TridentTuple input = this._inputFactory.create((TridentTupleView)tuple);
        if (!val.containsKey(group)) {
            curr = this._agg.init(arr[2], groupColl);
            val.put(group, curr);
        } else {
            curr = val.get(group);
        }
        groupColl.currGroup = group;
        this._agg.aggregate(curr, input, groupColl);
    }

    @Override
    public void complete(Object[] arr, TridentCollector collector) {
        Map val = (Map)arr[1];
        GroupCollector groupColl = (GroupCollector)arr[0];
        for (Map.Entry e : val.entrySet()) {
            groupColl.currGroup = (List)e.getKey();
            this._agg.complete(e.getValue(), groupColl);
        }
    }

    @Override
    public void cleanup() {
        this._agg.cleanup();
    }
}

