/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.operation.impl;

import backtype.storm.tuple.Fields;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import storm.trident.operation.GroupedMultiReducer;
import storm.trident.operation.MultiReducer;
import storm.trident.operation.TridentCollector;
import storm.trident.operation.TridentMultiReducerContext;
import storm.trident.tuple.TridentTuple;
import storm.trident.tuple.TridentTupleView;

public class GroupedMultiReducerExecutor
implements MultiReducer<Map<TridentTuple, Object>> {
    GroupedMultiReducer _reducer;
    List<Fields> _groupFields;
    List<Fields> _inputFields;
    List<TridentTupleView.ProjectionFactory> _groupFactories = new ArrayList<TridentTupleView.ProjectionFactory>();
    List<TridentTupleView.ProjectionFactory> _inputFactories = new ArrayList<TridentTupleView.ProjectionFactory>();

    public GroupedMultiReducerExecutor(GroupedMultiReducer reducer, List<Fields> groupFields, List<Fields> inputFields) {
        if (inputFields.size() != groupFields.size()) {
            throw new IllegalArgumentException("Multireducer groupFields and inputFields must be the same size");
        }
        this._groupFields = groupFields;
        this._inputFields = inputFields;
        this._reducer = reducer;
    }

    @Override
    public void prepare(Map conf, TridentMultiReducerContext context) {
        for (int i = 0; i < this._groupFields.size(); ++i) {
            this._groupFactories.add(context.makeProjectionFactory(i, this._groupFields.get(i)));
            this._inputFactories.add(context.makeProjectionFactory(i, this._inputFields.get(i)));
        }
        this._reducer.prepare(conf, new TridentMultiReducerContext(this._inputFactories));
    }

    @Override
    public Map<TridentTuple, Object> init(TridentCollector collector) {
        return new HashMap<TridentTuple, Object>();
    }

    @Override
    public void execute(Map<TridentTuple, Object> state, int streamIndex, TridentTuple full, TridentCollector collector) {
        Object curr;
        TridentTupleView.ProjectionFactory groupFactory = this._groupFactories.get(streamIndex);
        TridentTupleView.ProjectionFactory inputFactory = this._inputFactories.get(streamIndex);
        TridentTuple group = groupFactory.create(full);
        TridentTuple input = inputFactory.create(full);
        if (!state.containsKey(group)) {
            curr = this._reducer.init(collector, group);
            state.put(group, curr);
        } else {
            curr = state.get(group);
        }
        this._reducer.execute(curr, streamIndex, group, input, collector);
    }

    @Override
    public void complete(Map<TridentTuple, Object> state, TridentCollector collector) {
        for (Map.Entry<TridentTuple, Object> e : state.entrySet()) {
            TridentTuple group = e.getKey();
            Object val = e.getValue();
            this._reducer.complete(val, group, collector);
        }
    }

    @Override
    public void cleanup() {
        this._reducer.cleanup();
    }
}

