/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.partition;

import backtype.storm.generated.GlobalStreamId;
import backtype.storm.grouping.CustomStreamGrouping;
import backtype.storm.task.WorkerTopologyContext;
import java.util.Arrays;
import java.util.List;

public class IndexHashGrouping
implements CustomStreamGrouping {
    int _index;
    List<Integer> _targets;

    public static int objectToIndex(Object val, int numPartitions) {
        if (val == null) {
            return 0;
        }
        return Math.abs(val.hashCode()) % numPartitions;
    }

    public IndexHashGrouping(int index) {
        this._index = index;
    }

    @Override
    public void prepare(WorkerTopologyContext context, GlobalStreamId stream, List<Integer> targetTasks) {
        this._targets = targetTasks;
    }

    @Override
    public List<Integer> chooseTasks(int fromTask, List<Object> values) {
        int i = IndexHashGrouping.objectToIndex(values.get(this._index), this._targets.size());
        return Arrays.asList(this._targets.get(i));
    }
}

