/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.planner.processor;

import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Fields;
import java.util.List;
import java.util.Map;
import storm.trident.operation.Function;
import storm.trident.operation.TridentOperationContext;
import storm.trident.planner.ProcessorContext;
import storm.trident.planner.TridentProcessor;
import storm.trident.planner.processor.AppendCollector;
import storm.trident.planner.processor.TridentContext;
import storm.trident.tuple.TridentTuple;
import storm.trident.tuple.TridentTupleView;

public class EachProcessor
implements TridentProcessor {
    Function _function;
    TridentContext _context;
    AppendCollector _collector;
    Fields _inputFields;
    TridentTupleView.ProjectionFactory _projection;

    public EachProcessor(Fields inputFields, Function function) {
        this._function = function;
        this._inputFields = inputFields;
    }

    @Override
    public void prepare(Map conf, TopologyContext context, TridentContext tridentContext) {
        List<TridentTuple.Factory> parents = tridentContext.getParentTupleFactories();
        if (parents.size() != 1) {
            throw new RuntimeException("Each operation can only have one parent");
        }
        this._context = tridentContext;
        this._collector = new AppendCollector(tridentContext);
        this._projection = new TridentTupleView.ProjectionFactory(parents.get(0), this._inputFields);
        this._function.prepare(conf, new TridentOperationContext(context, (TridentTuple.Factory)this._projection));
    }

    @Override
    public void cleanup() {
        this._function.cleanup();
    }

    @Override
    public void execute(ProcessorContext processorContext, String streamId, TridentTuple tuple) {
        this._collector.setContext(processorContext, tuple);
        this._function.execute(this._projection.create(tuple), this._collector);
    }

    @Override
    public void startBatch(ProcessorContext processorContext) {
    }

    @Override
    public void finishBatch(ProcessorContext processorContext) {
    }

    @Override
    public TridentTuple.Factory getOutputFactory() {
        return this._collector.getOutputFactory();
    }
}

