/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.spout;

import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Fields;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import storm.trident.operation.TridentCollector;
import storm.trident.spout.ICommitterTridentSpout;
import storm.trident.spout.IOpaquePartitionedTridentSpout;
import storm.trident.spout.ISpoutPartition;
import storm.trident.spout.ITridentSpout;
import storm.trident.topology.TransactionAttempt;
import storm.trident.topology.state.RotatingTransactionalState;
import storm.trident.topology.state.TransactionalState;

public class OpaquePartitionedTridentSpoutExecutor
implements ICommitterTridentSpout<Object> {
    IOpaquePartitionedTridentSpout _spout;

    public OpaquePartitionedTridentSpoutExecutor(IOpaquePartitionedTridentSpout spout) {
        this._spout = spout;
    }

    @Override
    public ITridentSpout.BatchCoordinator<Object> getCoordinator(String txStateId, Map conf, TopologyContext context) {
        return new Coordinator(conf, context);
    }

    @Override
    public ICommitterTridentSpout.Emitter getEmitter(String txStateId, Map conf, TopologyContext context) {
        return new Emitter(txStateId, conf, context);
    }

    @Override
    public Fields getOutputFields() {
        return this._spout.getOutputFields();
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this._spout.getComponentConfiguration();
    }

    public class Emitter
    implements ICommitterTridentSpout.Emitter {
        IOpaquePartitionedTridentSpout.Emitter _emitter;
        TransactionalState _state;
        TreeMap<Long, Map<String, Object>> _cachedMetas = new TreeMap();
        Map<String, EmitterPartitionState> _partitionStates = new HashMap<String, EmitterPartitionState>();
        int _index;
        int _numTasks;
        Object _savedCoordinatorMeta = null;
        boolean _changedMeta = false;

        public Emitter(String txStateId, Map conf, TopologyContext context) {
            this._emitter = OpaquePartitionedTridentSpoutExecutor.this._spout.getEmitter(conf, context);
            this._index = context.getThisTaskIndex();
            this._numTasks = context.getComponentTasks(context.getThisComponentId()).size();
            this._state = TransactionalState.newUserState(conf, txStateId);
        }

        public void emitBatch(TransactionAttempt tx, Object coordinatorMeta, TridentCollector collector) {
            if (this._savedCoordinatorMeta == null || !this._savedCoordinatorMeta.equals(coordinatorMeta)) {
                List partitions = this._emitter.getOrderedPartitions(coordinatorMeta);
                this._partitionStates.clear();
                ArrayList<ISpoutPartition> myPartitions = new ArrayList<ISpoutPartition>();
                for (int i = this._index; i < partitions.size(); i += this._numTasks) {
                    ISpoutPartition p = (ISpoutPartition)partitions.get(i);
                    String id = p.getId();
                    myPartitions.add(p);
                    this._partitionStates.put(id, new EmitterPartitionState(new RotatingTransactionalState(this._state, id), p));
                }
                this._emitter.refreshPartitions(myPartitions);
                this._savedCoordinatorMeta = coordinatorMeta;
                this._changedMeta = true;
            }
            HashMap<String, Object> metas = new HashMap<String, Object>();
            this._cachedMetas.put(tx.getTransactionId(), metas);
            Map.Entry<Long, Map<String, Object>> entry = this._cachedMetas.lowerEntry(tx.getTransactionId());
            Map<String, Object> prevCached = entry != null ? entry.getValue() : new HashMap<String, Object>();
            for (String id : this._partitionStates.keySet()) {
                EmitterPartitionState s = this._partitionStates.get(id);
                s.rotatingState.removeState(tx.getTransactionId());
                Object lastMeta = prevCached.get(id);
                if (lastMeta == null) {
                    lastMeta = s.rotatingState.getLastState();
                }
                Object meta = this._emitter.emitPartitionBatch(tx, collector, s.partition, lastMeta);
                metas.put(id, meta);
            }
        }

        @Override
        public void success(TransactionAttempt tx) {
            for (EmitterPartitionState state : this._partitionStates.values()) {
                state.rotatingState.cleanupBefore(tx.getTransactionId());
            }
        }

        @Override
        public void commit(TransactionAttempt attempt) {
            if (this._changedMeta && this._index == 0) {
                HashSet<String> validIds = new HashSet<String>();
                for (ISpoutPartition p : this._emitter.getOrderedPartitions(this._savedCoordinatorMeta)) {
                    validIds.add(p.getId());
                }
                for (String existingPartition : this._state.list("")) {
                    if (validIds.contains(existingPartition)) continue;
                    RotatingTransactionalState s = new RotatingTransactionalState(this._state, existingPartition);
                    s.removeState(attempt.getTransactionId());
                }
                this._changedMeta = false;
            }
            Long txid = attempt.getTransactionId();
            Map<String, Object> metas = this._cachedMetas.remove(txid);
            for (String partitionId : metas.keySet()) {
                Object meta = metas.get(partitionId);
                this._partitionStates.get((Object)partitionId).rotatingState.overrideState(txid, meta);
            }
        }

        @Override
        public void close() {
            this._emitter.close();
        }
    }

    static class EmitterPartitionState {
        public RotatingTransactionalState rotatingState;
        public ISpoutPartition partition;

        public EmitterPartitionState(RotatingTransactionalState s, ISpoutPartition p) {
            this.rotatingState = s;
            this.partition = p;
        }
    }

    public class Coordinator
    implements ITridentSpout.BatchCoordinator<Object> {
        IOpaquePartitionedTridentSpout.Coordinator _coordinator;

        public Coordinator(Map conf, TopologyContext context) {
            this._coordinator = OpaquePartitionedTridentSpoutExecutor.this._spout.getCoordinator(conf, context);
        }

        @Override
        public Object initializeTransaction(long txid, Object prevMetadata, Object currMetadata) {
            return this._coordinator.getPartitionsForBatch();
        }

        @Override
        public void close() {
            this._coordinator.close();
        }

        @Override
        public void success(long txid) {
        }

        @Override
        public boolean isReady(long txid) {
            return this._coordinator.isReady(txid);
        }
    }
}

