/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.state.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import storm.trident.state.map.IBackingMap;
import storm.trident.util.LRUMap;

public class CachedMap<T>
implements IBackingMap<T> {
    LRUMap<List<Object>, T> _cache;
    IBackingMap<T> _delegate;

    public CachedMap(IBackingMap<T> delegate, int cacheSize) {
        this._cache = new LRUMap(cacheSize);
        this._delegate = delegate;
    }

    @Override
    public List<T> multiGet(List<List<Object>> keys) {
        HashMap<List, Object> results = new HashMap<List, Object>();
        ArrayList<List<Object>> toGet = new ArrayList<List<Object>>();
        for (List<Object> key : keys) {
            if (this._cache.containsKey(key)) {
                results.put(key, this._cache.get(key));
                continue;
            }
            toGet.add(key);
        }
        List<T> fetchedVals = this._delegate.multiGet(toGet);
        for (int i = 0; i < toGet.size(); ++i) {
            List key = (List)toGet.get(i);
            T val = fetchedVals.get(i);
            this._cache.put(key, val);
            results.put(key, val);
        }
        ArrayList ret = new ArrayList(keys.size());
        for (List<Object> key : keys) {
            ret.add(results.get(key));
        }
        return ret;
    }

    @Override
    public void multiPut(List<List<Object>> keys, List<T> values) {
        this.cache(keys, values);
        this._delegate.multiPut(keys, values);
    }

    private void cache(List<List<Object>> keys, List<T> values) {
        for (int i = 0; i < keys.size(); ++i) {
            this._cache.put(keys.get(i), values.get(i));
        }
    }
}

