/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.state.map;

import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Values;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import storm.trident.operation.CombinerAggregator;
import storm.trident.operation.TridentCollector;
import storm.trident.operation.TridentOperationContext;
import storm.trident.state.CombinerValueUpdater;
import storm.trident.state.StateUpdater;
import storm.trident.state.ValueUpdater;
import storm.trident.state.map.MapState;
import storm.trident.tuple.ComboList;
import storm.trident.tuple.TridentTuple;
import storm.trident.tuple.TridentTupleView;

public class MapCombinerAggStateUpdater
implements StateUpdater<MapState> {
    CombinerAggregator _agg;
    Fields _groupFields;
    Fields _inputFields;
    TridentTupleView.ProjectionFactory _groupFactory;
    TridentTupleView.ProjectionFactory _inputFactory;
    ComboList.Factory _factory;

    public MapCombinerAggStateUpdater(CombinerAggregator agg, Fields groupFields, Fields inputFields) {
        this._agg = agg;
        this._groupFields = groupFields;
        this._inputFields = inputFields;
        if (inputFields.size() != 1) {
            throw new IllegalArgumentException("Combiner aggs only take a single field as input. Got this instead: " + inputFields.toString());
        }
        this._factory = new ComboList.Factory(groupFields.size(), inputFields.size());
    }

    @Override
    public void updateState(MapState map, List<TridentTuple> tuples, TridentCollector collector) {
        ArrayList<List<Object>> groups = new ArrayList<List<Object>>(tuples.size());
        ArrayList<ValueUpdater> updaters = new ArrayList<ValueUpdater>(tuples.size());
        for (TridentTuple t : tuples) {
            groups.add(this._groupFactory.create(t));
            updaters.add(new CombinerValueUpdater(this._agg, this._inputFactory.create(t).getValue(0)));
        }
        List newVals = map.multiUpdate(groups, updaters);
        for (int i = 0; i < tuples.size(); ++i) {
            List key = (List)groups.get(i);
            Object result2 = newVals.get(i);
            collector.emit(this._factory.create(new List[]{key, new Values(result2)}));
        }
    }

    @Override
    public void prepare(Map conf, TridentOperationContext context) {
        this._groupFactory = context.makeProjectionFactory(this._groupFields);
        this._inputFactory = context.makeProjectionFactory(this._inputFields);
    }

    @Override
    public void cleanup() {
    }
}

