/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.testing;

import backtype.storm.Config;
import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Fields;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import storm.trident.operation.TridentCollector;
import storm.trident.spout.IBatchSpout;

public class FixedBatchSpout
implements IBatchSpout {
    Fields fields;
    List<Object>[] outputs;
    int maxBatchSize;
    HashMap<Long, List<List<Object>>> batches = new HashMap();
    int index = 0;
    boolean cycle = false;

    public FixedBatchSpout(Fields fields, int maxBatchSize, List<Object> ... outputs) {
        this.fields = fields;
        this.outputs = outputs;
        this.maxBatchSize = maxBatchSize;
    }

    public void setCycle(boolean cycle) {
        this.cycle = cycle;
    }

    @Override
    public void open(Map conf, TopologyContext context) {
        this.index = 0;
    }

    @Override
    public void emitBatch(long batchId, TridentCollector collector) {
        List<List<Object>> batch = this.batches.get(batchId);
        if (batch == null) {
            batch = new ArrayList<List<Object>>();
            if (this.index >= this.outputs.length && this.cycle) {
                this.index = 0;
            }
            for (int i = 0; this.index < this.outputs.length && i < this.maxBatchSize; ++i) {
                batch.add(this.outputs[this.index]);
                ++this.index;
            }
            this.batches.put(batchId, batch);
        }
        for (List<Object> list2 : batch) {
            collector.emit(list2);
        }
    }

    @Override
    public void ack(long batchId) {
        this.batches.remove(batchId);
    }

    @Override
    public void close() {
    }

    @Override
    public Map getComponentConfiguration() {
        Config conf = new Config();
        conf.setMaxTaskParallelism(1);
        return conf;
    }

    @Override
    public Fields getOutputFields() {
        return this.fields;
    }
}

