/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.testing;

import backtype.storm.task.IMetricsContext;
import backtype.storm.tuple.Values;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import storm.trident.state.ITupleCollection;
import storm.trident.state.OpaqueValue;
import storm.trident.state.State;
import storm.trident.state.StateFactory;
import storm.trident.state.ValueUpdater;
import storm.trident.state.map.IBackingMap;
import storm.trident.state.map.MapState;
import storm.trident.state.map.OpaqueMap;
import storm.trident.state.map.SnapshottableMap;
import storm.trident.state.snapshot.Snapshottable;
import storm.trident.util.LRUMap;

public class LRUMemoryMapState<T>
implements Snapshottable<T>,
ITupleCollection,
MapState<T> {
    LRUMemoryMapStateBacking<OpaqueValue> _backing;
    SnapshottableMap<T> _delegate;
    static ConcurrentHashMap<String, Map<List<Object>, Object>> _dbs = new ConcurrentHashMap();

    public LRUMemoryMapState(int cacheSize, String id) {
        this._backing = new LRUMemoryMapStateBacking(cacheSize, id);
        this._delegate = new SnapshottableMap(OpaqueMap.build(this._backing), new Values("$MEMORY-MAP-STATE-GLOBAL$"));
    }

    @Override
    public T update(ValueUpdater updater) {
        return this._delegate.update(updater);
    }

    @Override
    public void set(T o) {
        this._delegate.set(o);
    }

    @Override
    public T get() {
        return this._delegate.get();
    }

    @Override
    public void beginCommit(Long txid) {
        this._delegate.beginCommit(txid);
    }

    @Override
    public void commit(Long txid) {
        this._delegate.commit(txid);
    }

    @Override
    public Iterator<List<Object>> getTuples() {
        return this._backing.getTuples();
    }

    @Override
    public List<T> multiUpdate(List<List<Object>> keys, List<ValueUpdater> updaters) {
        return this._delegate.multiUpdate(keys, updaters);
    }

    @Override
    public void multiPut(List<List<Object>> keys, List<T> vals) {
        this._delegate.multiPut(keys, vals);
    }

    @Override
    public List<T> multiGet(List<List<Object>> keys) {
        return this._delegate.multiGet(keys);
    }

    static class LRUMemoryMapStateBacking<T>
    implements IBackingMap<T>,
    ITupleCollection {
        Map<List<Object>, T> db;
        Long currTx;

        public static void clearAll() {
            _dbs.clear();
        }

        public LRUMemoryMapStateBacking(int cacheSize, String id) {
            if (!_dbs.containsKey(id)) {
                _dbs.put(id, new LRUMap(cacheSize));
            }
            this.db = _dbs.get(id);
        }

        @Override
        public List<T> multiGet(List<List<Object>> keys) {
            ArrayList<T> ret = new ArrayList<T>();
            for (List<Object> key : keys) {
                ret.add(this.db.get(key));
            }
            return ret;
        }

        @Override
        public void multiPut(List<List<Object>> keys, List<T> vals) {
            for (int i = 0; i < keys.size(); ++i) {
                List<Object> key = keys.get(i);
                T val = vals.get(i);
                this.db.put(key, val);
            }
        }

        @Override
        public Iterator<List<Object>> getTuples() {
            return new Iterator<List<Object>>(){
                private Iterator<Map.Entry<List<Object>, T>> it;
                {
                    this.it = LRUMemoryMapStateBacking.this.db.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public List<Object> next() {
                    Map.Entry e = this.it.next();
                    ArrayList<Object> ret = new ArrayList<Object>();
                    ret.addAll((Collection)e.getKey());
                    ret.add(((OpaqueValue)e.getValue()).getCurr());
                    return ret;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
        }
    }

    public static class Factory
    implements StateFactory {
        String _id = UUID.randomUUID().toString();
        int _maxSize;

        public Factory(int maxSize) {
            this._maxSize = maxSize;
        }

        @Override
        public State makeState(Map conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
            return new LRUMemoryMapState(this._maxSize, this._id + partitionIndex);
        }
    }
}

