/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.topology.state;

import backtype.storm.utils.Utils;
import java.util.HashSet;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.zookeeper.KeeperException;
import storm.trident.topology.state.TransactionalState;

public class RotatingTransactionalState {
    private TransactionalState _state;
    private String _subdir;
    private TreeMap<Long, Object> _curr = new TreeMap();

    public RotatingTransactionalState(TransactionalState state, String subdir) {
        this._state = state;
        this._subdir = subdir;
        state.mkdir(subdir);
        this.sync();
    }

    public Object getLastState() {
        if (this._curr.isEmpty()) {
            return null;
        }
        return this._curr.lastEntry().getValue();
    }

    public void overrideState(long txid, Object state) {
        this._state.setData(this.txPath(txid), state);
        this._curr.put(txid, state);
    }

    public void removeState(long txid) {
        if (this._curr.containsKey(txid)) {
            this._curr.remove(txid);
            this._state.delete(this.txPath(txid));
        }
    }

    public Object getState(long txid) {
        return this._curr.get(txid);
    }

    public Object getState(long txid, StateInitializer init) {
        if (!this._curr.containsKey(txid)) {
            Object data;
            SortedMap<Long, Object> prevMap = this._curr.headMap(txid);
            SortedMap<Long, Object> afterMap = this._curr.tailMap(txid);
            Long prev = null;
            if (!prevMap.isEmpty()) {
                prev = prevMap.lastKey();
            }
            if (afterMap.isEmpty()) {
                Object prevData = prev != null ? this._curr.get(prev) : null;
                data = init.init(txid, prevData);
            } else {
                data = null;
            }
            this._curr.put(txid, data);
            this._state.setData(this.txPath(txid), data);
        }
        return this._curr.get(txid);
    }

    public Object getPreviousState(long txid) {
        SortedMap<Long, Object> prevMap = this._curr.headMap(txid);
        if (prevMap.isEmpty()) {
            return null;
        }
        return prevMap.get(prevMap.lastKey());
    }

    public boolean hasCache(long txid) {
        return this._curr.containsKey(txid);
    }

    public Object getStateOrCreate(long txid, StateInitializer init) {
        if (this._curr.containsKey(txid)) {
            return this._curr.get(txid);
        }
        this.getState(txid, init);
        return null;
    }

    public void cleanupBefore(long txid) {
        SortedMap<Long, Object> toDelete = this._curr.headMap(txid);
        for (long tx : new HashSet<Long>(toDelete.keySet())) {
            this._curr.remove(tx);
            try {
                this._state.delete(this.txPath(tx));
            }
            catch (RuntimeException e) {
                if (Utils.exceptionCauseIsInstanceOf(KeeperException.NoNodeException.class, e)) continue;
                throw e;
            }
        }
    }

    private void sync() {
        List<String> txids = this._state.list(this._subdir);
        for (String txid_s : txids) {
            Object data = this._state.getData(this.txPath(txid_s));
            this._curr.put(Long.parseLong(txid_s), data);
        }
    }

    private String txPath(long tx) {
        return this.txPath("" + tx);
    }

    private String txPath(String tx) {
        return this._subdir + "/" + tx;
    }

    public static interface StateInitializer {
        public Object init(long var1, Object var3);
    }
}

