/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.tuple;

import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentVector;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import storm.trident.tuple.TridentTuple;
import storm.trident.tuple.ValuePointer;

public class TridentTupleView
extends AbstractList<Object>
implements TridentTuple {
    ValuePointer[] _index;
    Map<String, ValuePointer> _fieldIndex;
    IPersistentVector _delegates;
    public static TridentTupleView EMPTY_TUPLE = new TridentTupleView(null, new ValuePointer[0], new HashMap<String, ValuePointer>());

    private static List<String> indexToFieldsList(ValuePointer[] index) {
        ArrayList<String> ret = new ArrayList<String>();
        for (ValuePointer p : index) {
            ret.add(p.field);
        }
        return ret;
    }

    public TridentTupleView(IPersistentVector delegates, ValuePointer[] index, Map<String, ValuePointer> fieldIndex) {
        this._delegates = delegates;
        this._index = index;
        this._fieldIndex = fieldIndex;
    }

    public static TridentTuple createFreshTuple(Fields fields, List<Object> values) {
        FreshOutputFactory factory = new FreshOutputFactory(fields);
        return factory.create(values);
    }

    public static TridentTuple createFreshTuple(Fields fields, Object ... values) {
        FreshOutputFactory factory = new FreshOutputFactory(fields);
        return factory.create(Arrays.asList(values));
    }

    @Override
    public List<Object> getValues() {
        return this;
    }

    @Override
    public int size() {
        return this._index.length;
    }

    @Override
    public boolean contains(String field) {
        return this.getFields().contains(field);
    }

    @Override
    public Fields getFields() {
        return new Fields(TridentTupleView.indexToFieldsList(this._index));
    }

    @Override
    public int fieldIndex(String field) {
        return this.getFields().fieldIndex(field);
    }

    @Override
    public List<Object> select(Fields selector) {
        return this.getFields().select(selector, this.getValues());
    }

    @Override
    public Object get(int i) {
        return this.getValue(i);
    }

    @Override
    public Object getValue(int i) {
        return this.getValueByPointer(this._index[i]);
    }

    @Override
    public String getString(int i) {
        return (String)this.getValue(i);
    }

    @Override
    public Integer getInteger(int i) {
        return (Integer)this.getValue(i);
    }

    @Override
    public Long getLong(int i) {
        return (Long)this.getValue(i);
    }

    @Override
    public Boolean getBoolean(int i) {
        return (Boolean)this.getValue(i);
    }

    @Override
    public Short getShort(int i) {
        return (Short)this.getValue(i);
    }

    @Override
    public Byte getByte(int i) {
        return (Byte)this.getValue(i);
    }

    @Override
    public Double getDouble(int i) {
        return (Double)this.getValue(i);
    }

    @Override
    public Float getFloat(int i) {
        return (Float)this.getValue(i);
    }

    @Override
    public byte[] getBinary(int i) {
        return (byte[])this.getValue(i);
    }

    @Override
    public Object getValueByField(String field) {
        return this.getValueByPointer(this._fieldIndex.get(field));
    }

    @Override
    public String getStringByField(String field) {
        return (String)this.getValueByField(field);
    }

    @Override
    public Integer getIntegerByField(String field) {
        return (Integer)this.getValueByField(field);
    }

    @Override
    public Long getLongByField(String field) {
        return (Long)this.getValueByField(field);
    }

    @Override
    public Boolean getBooleanByField(String field) {
        return (Boolean)this.getValueByField(field);
    }

    @Override
    public Short getShortByField(String field) {
        return (Short)this.getValueByField(field);
    }

    @Override
    public Byte getByteByField(String field) {
        return (Byte)this.getValueByField(field);
    }

    @Override
    public Double getDoubleByField(String field) {
        return (Double)this.getValueByField(field);
    }

    @Override
    public Float getFloatByField(String field) {
        return (Float)this.getValueByField(field);
    }

    @Override
    public byte[] getBinaryByField(String field) {
        return (byte[])this.getValueByField(field);
    }

    private Object getValueByPointer(ValuePointer ptr) {
        return ((List)this._delegates.nth(ptr.delegateIndex)).get(ptr.index);
    }

    public static class RootFactory
    implements TridentTuple.Factory {
        ValuePointer[] index;
        Map<String, ValuePointer> fieldIndex;

        public RootFactory(Fields inputFields) {
            this.index = new ValuePointer[inputFields.size()];
            int i = 0;
            for (String f : inputFields) {
                this.index[i] = new ValuePointer(0, i, f);
                ++i;
            }
            this.fieldIndex = ValuePointer.buildFieldIndex(this.index);
        }

        public TridentTuple create(Tuple parent) {
            return new TridentTupleView((IPersistentVector)PersistentVector.EMPTY.cons(parent.getValues()), this.index, this.fieldIndex);
        }

        @Override
        public Map<String, ValuePointer> getFieldIndex() {
            return this.fieldIndex;
        }

        @Override
        public int numDelegates() {
            return 1;
        }

        @Override
        public List<String> getOutputFields() {
            return TridentTupleView.indexToFieldsList(this.index);
        }
    }

    public static class OperationOutputFactory
    implements TridentTuple.Factory {
        Map<String, ValuePointer> _fieldIndex;
        ValuePointer[] _index;
        TridentTuple.Factory _parent;

        public OperationOutputFactory(TridentTuple.Factory parent, Fields selfFields) {
            this._parent = parent;
            this._fieldIndex = new HashMap<String, ValuePointer>(parent.getFieldIndex());
            int myIndex = parent.numDelegates();
            for (int i = 0; i < selfFields.size(); ++i) {
                String field = selfFields.get(i);
                this._fieldIndex.put(field, new ValuePointer(myIndex, i, field));
            }
            ArrayList<String> myOrder = new ArrayList<String>(parent.getOutputFields());
            HashSet<String> parentFieldsSet = new HashSet<String>(myOrder);
            for (String f : selfFields) {
                if (parentFieldsSet.contains(f)) {
                    throw new IllegalArgumentException("Additive operations cannot add fields with same name as already exists. Tried adding " + selfFields + " to " + parent.getOutputFields());
                }
                myOrder.add(f);
            }
            this._index = ValuePointer.buildIndex(new Fields(myOrder), this._fieldIndex);
        }

        public TridentTuple create(TridentTupleView parent, List<Object> selfVals) {
            IPersistentVector curr = parent._delegates;
            curr = (IPersistentVector)RT.conj((IPersistentCollection)curr, selfVals);
            return new TridentTupleView(curr, this._index, this._fieldIndex);
        }

        @Override
        public Map<String, ValuePointer> getFieldIndex() {
            return this._fieldIndex;
        }

        @Override
        public int numDelegates() {
            return this._parent.numDelegates() + 1;
        }

        @Override
        public List<String> getOutputFields() {
            return TridentTupleView.indexToFieldsList(this._index);
        }
    }

    public static class FreshOutputFactory
    implements TridentTuple.Factory {
        Map<String, ValuePointer> _fieldIndex = new HashMap<String, ValuePointer>();
        ValuePointer[] _index;

        public FreshOutputFactory(Fields selfFields) {
            for (int i = 0; i < selfFields.size(); ++i) {
                String field = selfFields.get(i);
                this._fieldIndex.put(field, new ValuePointer(0, i, field));
            }
            this._index = ValuePointer.buildIndex(selfFields, this._fieldIndex);
        }

        public TridentTuple create(List<Object> selfVals) {
            return new TridentTupleView((IPersistentVector)PersistentVector.EMPTY.cons(selfVals), this._index, this._fieldIndex);
        }

        @Override
        public Map<String, ValuePointer> getFieldIndex() {
            return this._fieldIndex;
        }

        @Override
        public int numDelegates() {
            return 1;
        }

        @Override
        public List<String> getOutputFields() {
            return TridentTupleView.indexToFieldsList(this._index);
        }
    }

    public static class ProjectionFactory
    implements TridentTuple.Factory {
        Map<String, ValuePointer> _fieldIndex;
        ValuePointer[] _index;
        TridentTuple.Factory _parent;

        public ProjectionFactory(TridentTuple.Factory parent, Fields projectFields) {
            this._parent = parent;
            if (projectFields == null) {
                projectFields = new Fields(new String[0]);
            }
            Map<String, ValuePointer> parentFieldIndex = parent.getFieldIndex();
            this._fieldIndex = new HashMap<String, ValuePointer>();
            for (String f : projectFields) {
                this._fieldIndex.put(f, parentFieldIndex.get(f));
            }
            this._index = ValuePointer.buildIndex(projectFields, this._fieldIndex);
        }

        public TridentTuple create(TridentTuple parent) {
            if (this._index.length == 0) {
                return EMPTY_TUPLE;
            }
            return new TridentTupleView(((TridentTupleView)parent)._delegates, this._index, this._fieldIndex);
        }

        @Override
        public Map<String, ValuePointer> getFieldIndex() {
            return this._fieldIndex;
        }

        @Override
        public int numDelegates() {
            return this._parent.numDelegates();
        }

        @Override
        public List<String> getOutputFields() {
            return TridentTupleView.indexToFieldsList(this._index);
        }
    }
}

