/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jvm.sandbox.api.listener.ext;

import com.alibaba.jvm.sandbox.api.event.Event;
import com.alibaba.jvm.sandbox.api.listener.ext.Attachment;
import com.alibaba.jvm.sandbox.api.listener.ext.Behavior;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Advice
implements Attachment {
    private final int processId;
    private final int invokeId;
    private final Behavior behavior;
    private final Object[] parameterArray;
    private final Object target;
    private Object returnObj;
    private Throwable throwable;
    private Object attachment;
    private Set<String> marks = new HashSet<String>();
    private Advice top = this;
    private Advice parent = this;
    private Event.Type state = Event.Type.BEFORE;

    Advice(int processId, int invokeId, Behavior behavior, Object[] parameterArray, Object target) {
        this.processId = processId;
        this.invokeId = invokeId;
        this.behavior = behavior;
        this.parameterArray = parameterArray;
        this.target = target;
    }

    Advice applyBefore(Advice top, Advice parent) {
        this.top = top;
        this.parent = parent;
        return this;
    }

    Advice applyReturn(Object returnObj) {
        this.returnObj = returnObj;
        this.state = Event.Type.RETURN;
        return this;
    }

    Advice applyThrows(Throwable throwable) {
        this.throwable = throwable;
        this.state = Event.Type.THROWS;
        return this;
    }

    public boolean isReturn() {
        return this.state == Event.Type.RETURN;
    }

    public boolean isThrows() {
        return this.state == Event.Type.THROWS;
    }

    public Advice changeParameter(int index, Object changeValue) {
        this.parameterArray[index] = changeValue;
        return this;
    }

    public int getProcessId() {
        return this.processId;
    }

    public int getInvokeId() {
        return this.invokeId;
    }

    public Behavior getBehavior() {
        return this.behavior;
    }

    public Object[] getParameterArray() {
        return this.parameterArray;
    }

    public Object getTarget() {
        return this.target;
    }

    public Object getReturnObj() {
        return this.returnObj;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public void attach(Object attachment) {
        this.attachment = attachment;
    }

    public <E> E attachment() {
        return (E)this.attachment;
    }

    public int hashCode() {
        return this.processId + this.invokeId;
    }

    public boolean equals(Object obj) {
        if (null == obj || !(obj instanceof Advice)) {
            return false;
        }
        Advice advice = (Advice)obj;
        return this.processId == advice.processId && this.invokeId == advice.invokeId;
    }

    public void mark(String mark) {
        this.marks.add(mark);
    }

    public boolean hasMark(String exceptMark) {
        return this.marks.contains(exceptMark);
    }

    public boolean unMark(String mark) {
        return this.marks.remove(mark);
    }

    public void attach(Object attachment, String mark) {
        this.attach(attachment);
        this.mark(mark);
    }

    public boolean isProcessTop() {
        return this.parent == this;
    }

    public Advice getProcessTop() {
        return this.top;
    }

    public List<Advice> listHasMarkOnChain(String exceptMark) {
        ArrayList<Advice> advices = new ArrayList<Advice>();
        if (this.hasMark(exceptMark)) {
            advices.add(this);
        }
        if (!this.isProcessTop()) {
            advices.addAll(this.parent.listHasMarkOnChain(exceptMark));
        }
        return advices;
    }
}

