/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jvm.sandbox.api.util;

import com.alibaba.jvm.sandbox.api.util.GaArrayUtils;

public class GaStringUtils {
    public static String getJavaClassName(Class<?> clazz) {
        return clazz.isArray() ? clazz.getCanonicalName() : clazz.getName();
    }

    public static String[] getJavaClassNameArray(Class<?>[] classArray) {
        if (GaArrayUtils.isEmpty(classArray)) {
            return null;
        }
        String[] javaClassNameArray = new String[classArray.length];
        for (int index = 0; index < classArray.length; ++index) {
            javaClassNameArray[index] = GaStringUtils.getJavaClassName(classArray[index]);
        }
        return javaClassNameArray;
    }

    public static boolean isEmpty(String string) {
        return null == string || string.isEmpty();
    }

    public static boolean matching(String string, String wildcard) {
        return null != wildcard && null != string && GaStringUtils.matching(string, wildcard, 0, 0);
    }

    private static boolean matching(String string, String wildcard, int stringStartNdx, int patternStartNdx) {
        int pNdx = patternStartNdx;
        int sNdx = stringStartNdx;
        int pLen = wildcard.length();
        if (pLen == 1 && wildcard.charAt(0) == '*') {
            return true;
        }
        int sLen = string.length();
        boolean nextIsNotWildcard = false;
        while (true) {
            if (sNdx >= sLen) {
                while (pNdx < pLen && wildcard.charAt(pNdx) == '*') {
                    ++pNdx;
                }
                return pNdx >= pLen;
            }
            if (pNdx >= pLen) {
                return false;
            }
            char p = wildcard.charAt(pNdx);
            if (!nextIsNotWildcard) {
                if (p == '\\') {
                    ++pNdx;
                    nextIsNotWildcard = true;
                    continue;
                }
                if (p == '?') {
                    ++sNdx;
                    ++pNdx;
                    continue;
                }
                if (p == '*') {
                    int pnext = 0;
                    if (pNdx + 1 < pLen) {
                        pnext = wildcard.charAt(pNdx + 1);
                    }
                    if (pnext == 42) {
                        ++pNdx;
                        continue;
                    }
                    ++pNdx;
                    for (int i = string.length(); i >= sNdx; --i) {
                        if (!GaStringUtils.matching(string, wildcard, i, pNdx)) continue;
                        return true;
                    }
                    return false;
                }
            } else {
                nextIsNotWildcard = false;
            }
            if (p != string.charAt(sNdx)) {
                return false;
            }
            ++sNdx;
            ++pNdx;
        }
    }
}

