/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.core.env;

import com.alibaba.nacos.spring.context.annotation.config.NacosPropertySources;
import com.alibaba.nacos.spring.context.event.config.NacosConfigMetadataEvent;
import com.alibaba.nacos.spring.core.env.AbstractNacosPropertySourceBuilder;
import com.alibaba.nacos.spring.core.env.NacosPropertySource;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.core.type.AnnotationMetadata;

public class AnnotationNacosPropertySourceBuilder
extends AbstractNacosPropertySourceBuilder<AnnotatedBeanDefinition> {
    public static final String BEAN_NAME = "annotationNacosPropertySourceBuilder";

    @Override
    protected Map<String, Object>[] resolveRuntimeAttributesArray(AnnotatedBeanDefinition beanDefinition, Properties globalNacosProperties) {
        AnnotationMetadata metadata = beanDefinition.getMetadata();
        Set annotationTypes = metadata.getAnnotationTypes();
        LinkedList<Map<String, Object>> annotationAttributesList = new LinkedList<Map<String, Object>>();
        for (String annotationType : annotationTypes) {
            annotationAttributesList.addAll(this.getAnnotationAttributesList(metadata, annotationType));
        }
        return annotationAttributesList.toArray(new Map[0]);
    }

    private List<Map<String, Object>> getAnnotationAttributesList(AnnotationMetadata metadata, String annotationType) {
        LinkedList<Map<String, Object>> annotationAttributesList = new LinkedList<Map<String, Object>>();
        if (NacosPropertySources.class.getName().equals(annotationType)) {
            Map annotationAttributes = metadata.getAnnotationAttributes(annotationType);
            if (annotationAttributes != null) {
                annotationAttributesList.addAll(Arrays.asList((Map[])annotationAttributes.get("value")));
            }
        } else if (com.alibaba.nacos.spring.context.annotation.config.NacosPropertySource.class.getName().equals(annotationType)) {
            annotationAttributesList.add(metadata.getAnnotationAttributes(annotationType));
        }
        return annotationAttributesList;
    }

    @Override
    protected void initNacosPropertySource(NacosPropertySource nacosPropertySource, AnnotatedBeanDefinition beanDefinition, Map<String, Object> annotationAttributes) {
        this.initAttributesMetadata(nacosPropertySource, annotationAttributes);
        this.initAutoRefreshed(nacosPropertySource, annotationAttributes);
        this.initOrigin(nacosPropertySource, beanDefinition);
        this.initOrder(nacosPropertySource, annotationAttributes);
    }

    private void initAttributesMetadata(NacosPropertySource nacosPropertySource, Map<String, Object> annotationAttributes) {
        nacosPropertySource.setAttributesMetadata(annotationAttributes);
    }

    private void initAutoRefreshed(NacosPropertySource nacosPropertySource, Map<String, Object> annotationAttributes) {
        boolean autoRefreshed = Boolean.TRUE.equals(annotationAttributes.get("autoRefreshed"));
        nacosPropertySource.setAutoRefreshed(autoRefreshed);
    }

    private void initOrigin(NacosPropertySource nacosPropertySource, AnnotatedBeanDefinition beanDefinition) {
        AnnotationMetadata metadata = beanDefinition.getMetadata();
        nacosPropertySource.setOrigin(metadata.getClassName());
    }

    private void initOrder(NacosPropertySource nacosPropertySource, Map<String, Object> annotationAttributes) {
        boolean first = Boolean.TRUE.equals(annotationAttributes.get("first"));
        String before = (String)annotationAttributes.get("before");
        String after = (String)annotationAttributes.get("after");
        nacosPropertySource.setFirst(first);
        nacosPropertySource.setBefore(before);
        nacosPropertySource.setAfter(after);
    }

    @Override
    protected NacosConfigMetadataEvent createMetaEvent(NacosPropertySource nacosPropertySource, AnnotatedBeanDefinition beanDefinition) {
        return new NacosConfigMetadataEvent(beanDefinition.getMetadata());
    }

    @Override
    protected void doInitMetadataEvent(NacosPropertySource nacosPropertySource, AnnotatedBeanDefinition beanDefinition, NacosConfigMetadataEvent metadataEvent) {
        metadataEvent.setAnnotatedElement(metadataEvent.getAnnotatedElement());
    }
}

