/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.factory;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.spring.context.event.config.EventPublishingConfigService;
import com.alibaba.nacos.spring.factory.DelegatingNamingService;
import com.alibaba.nacos.spring.factory.NacosServiceFactory;
import com.alibaba.nacos.spring.util.NacosBeanUtils;
import com.alibaba.nacos.spring.util.NacosUtils;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class CacheableEventPublishingNacosServiceFactory
implements NacosServiceFactory,
ApplicationContextAware {
    private final Map<String, ConfigService> configServicesCache = new LinkedHashMap<String, ConfigService>(2);
    private final Map<String, NamingService> namingServicesCache = new LinkedHashMap<String, NamingService>(2);
    private ConfigurableApplicationContext context;
    private ExecutorService nacosConfigListenerExecutor;

    @Override
    public ConfigService createConfigService(Properties properties) throws NacosException {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)properties);
        String cacheKey = NacosUtils.identify(copy);
        ConfigService configService = this.configServicesCache.get(cacheKey);
        if (configService == null) {
            configService = this.doCreateConfigService(copy);
            this.configServicesCache.put(cacheKey, configService);
        }
        return configService;
    }

    private ConfigService doCreateConfigService(Properties properties) throws NacosException {
        ConfigService configService = NacosFactory.createConfigService((Properties)properties);
        return new EventPublishingConfigService(configService, properties, this.context, this.nacosConfigListenerExecutor);
    }

    @Override
    public NamingService createNamingService(Properties properties) throws NacosException {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)properties);
        String cacheKey = NacosUtils.identify(copy);
        NamingService namingService = this.namingServicesCache.get(cacheKey);
        if (namingService == null) {
            namingService = new DelegatingNamingService(NacosFactory.createNamingService((Properties)copy), properties);
            this.namingServicesCache.put(cacheKey, namingService);
        }
        return namingService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = (ConfigurableApplicationContext)applicationContext;
        this.nacosConfigListenerExecutor = NacosBeanUtils.getNacosConfigListenerExecutorIfPresent((BeanFactory)applicationContext);
    }

    @Override
    public Collection<ConfigService> getConfigServices() {
        return this.configServicesCache.values();
    }

    @Override
    public Collection<NamingService> getNamingServices() {
        return this.namingServicesCache.values();
    }
}

