/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.factory;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingMaintainService;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.spring.context.event.config.EventPublishingConfigService;
import com.alibaba.nacos.spring.factory.DelegatingNamingMaintainService;
import com.alibaba.nacos.spring.factory.DelegatingNamingService;
import com.alibaba.nacos.spring.factory.NacosServiceFactory;
import com.alibaba.nacos.spring.util.NacosBeanUtils;
import com.alibaba.nacos.spring.util.NacosUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class CacheableEventPublishingNacosServiceFactory
implements NacosServiceFactory {
    private static volatile CacheableEventPublishingNacosServiceFactory SINGLETON = new CacheableEventPublishingNacosServiceFactory();
    private final Map<String, ConfigService> configServicesCache = new LinkedHashMap<String, ConfigService>(2);
    private final Map<String, NamingService> namingServicesCache = new LinkedHashMap<String, NamingService>(2);
    private final Map<String, NamingMaintainService> maintainServiceCache = new LinkedHashMap<String, NamingMaintainService>(2);
    private final LinkedList<DeferServiceHolder> deferServiceCache = new LinkedList();
    private ConfigurableApplicationContext context;
    private ExecutorService nacosConfigListenerExecutor;
    private Map<ServiceType, AbstractCreateWorker> createWorkerManager = new HashMap<ServiceType, AbstractCreateWorker>(3);

    public CacheableEventPublishingNacosServiceFactory() {
        this.createWorkerManager.put(ServiceType.CONFIG, new ConfigCreateWorker());
        this.createWorkerManager.put(ServiceType.NAMING, new NamingCreateWorker());
        this.createWorkerManager.put(ServiceType.MAINTAIN, new MaintainCreateWorker());
        this.createWorkerManager = Collections.unmodifiableMap(this.createWorkerManager);
    }

    public static CacheableEventPublishingNacosServiceFactory getSingleton() {
        return SINGLETON;
    }

    @Override
    public ConfigService createConfigService(Properties properties) throws NacosException {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)properties);
        return this.createWorkerManager.get((Object)ServiceType.CONFIG).run(copy, null);
    }

    @Override
    public NamingService createNamingService(Properties properties) throws NacosException {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)properties);
        return this.createWorkerManager.get((Object)ServiceType.NAMING).run(copy, null);
    }

    @Override
    public NamingMaintainService createNamingMaintainService(Properties properties) throws NacosException {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)properties);
        return this.createWorkerManager.get((Object)ServiceType.MAINTAIN).run(copy, null);
    }

    public <T> T deferCreateService(T service, Properties properties) {
        DeferServiceHolder serviceHolder = new DeferServiceHolder();
        serviceHolder.setHolder(service);
        serviceHolder.setProperties(properties);
        this.deferServiceCache.add(serviceHolder);
        return service;
    }

    public void publishDeferService(ApplicationContext context) throws NacosException {
        this.setApplicationContext(context);
        for (DeferServiceHolder holder : this.deferServiceCache) {
            Object o = holder.getHolder();
            Properties properties = holder.getProperties();
            if (o instanceof ConfigService) {
                ConfigService configService = (ConfigService)o;
                this.createWorkerManager.get((Object)ServiceType.CONFIG).run(properties, configService);
                continue;
            }
            if (o instanceof NamingService) {
                NamingService namingService = (NamingService)o;
                this.createWorkerManager.get((Object)ServiceType.NAMING).run(properties, namingService);
                continue;
            }
            if (!(o instanceof NamingMaintainService)) continue;
            NamingMaintainService maintainService = (NamingMaintainService)o;
            this.createWorkerManager.get((Object)ServiceType.MAINTAIN).run(properties, maintainService);
        }
        this.deferServiceCache.clear();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = (ConfigurableApplicationContext)applicationContext;
        this.nacosConfigListenerExecutor = CacheableEventPublishingNacosServiceFactory.getSingleton().nacosConfigListenerExecutor == null ? NacosBeanUtils.getNacosConfigListenerExecutorIfPresent((BeanFactory)applicationContext) : CacheableEventPublishingNacosServiceFactory.getSingleton().nacosConfigListenerExecutor;
    }

    @Override
    public Collection<ConfigService> getConfigServices() {
        return this.configServicesCache.values();
    }

    @Override
    public Collection<NamingService> getNamingServices() {
        return this.namingServicesCache.values();
    }

    @Override
    public Collection<NamingMaintainService> getNamingMaintainService() {
        return this.maintainServiceCache.values();
    }

    private static enum ServiceType {
        CONFIG,
        NAMING,
        MAINTAIN;

    }

    class ConfigCreateWorker
    extends AbstractCreateWorker<ConfigService> {
        ConfigCreateWorker() {
        }

        @Override
        public ConfigService run(Properties properties, ConfigService service) throws NacosException {
            String cacheKey = NacosUtils.identify(properties);
            ConfigService configService = (ConfigService)CacheableEventPublishingNacosServiceFactory.this.configServicesCache.get(cacheKey);
            if (configService == null) {
                if (service == null) {
                    service = NacosFactory.createConfigService((Properties)properties);
                }
                configService = new EventPublishingConfigService(service, properties, CacheableEventPublishingNacosServiceFactory.getSingleton().context, CacheableEventPublishingNacosServiceFactory.getSingleton().nacosConfigListenerExecutor);
                CacheableEventPublishingNacosServiceFactory.this.configServicesCache.put(cacheKey, configService);
            }
            return configService;
        }
    }

    class NamingCreateWorker
    extends AbstractCreateWorker<NamingService> {
        NamingCreateWorker() {
        }

        @Override
        public NamingService run(Properties properties, NamingService service) throws NacosException {
            String cacheKey = NacosUtils.identify(properties);
            NamingService namingService = (NamingService)CacheableEventPublishingNacosServiceFactory.this.namingServicesCache.get(cacheKey);
            if (namingService == null) {
                if (service == null) {
                    service = NacosFactory.createNamingService((Properties)properties);
                }
                namingService = new DelegatingNamingService(service, properties);
                CacheableEventPublishingNacosServiceFactory.this.namingServicesCache.put(cacheKey, namingService);
            }
            return namingService;
        }
    }

    class MaintainCreateWorker
    extends AbstractCreateWorker<NamingMaintainService> {
        MaintainCreateWorker() {
        }

        @Override
        public NamingMaintainService run(Properties properties, NamingMaintainService service) throws NacosException {
            String cacheKey = NacosUtils.identify(properties);
            NamingMaintainService namingMaintainService = (NamingMaintainService)CacheableEventPublishingNacosServiceFactory.this.maintainServiceCache.get(cacheKey);
            if (namingMaintainService == null) {
                if (service == null) {
                    service = NacosFactory.createMaintainService((Properties)properties);
                }
                namingMaintainService = new DelegatingNamingMaintainService(service, properties);
                CacheableEventPublishingNacosServiceFactory.this.maintainServiceCache.put(cacheKey, namingMaintainService);
            }
            return namingMaintainService;
        }
    }

    static abstract class AbstractCreateWorker<T> {
        AbstractCreateWorker() {
        }

        public abstract T run(Properties var1, T var2) throws NacosException;
    }

    static class DeferServiceHolder {
        private Properties properties;
        private Object holder;
        private ServiceType type;

        DeferServiceHolder() {
        }

        public Properties getProperties() {
            return this.properties;
        }

        public void setProperties(Properties properties) {
            this.properties = properties;
        }

        Object getHolder() {
            return this.holder;
        }

        void setHolder(Object holder) {
            this.holder = holder;
        }

        public ServiceType getType() {
            return this.type;
        }

        public void setType(ServiceType type) {
            this.type = type;
        }
    }
}

