/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.instance.core;

import com.alibaba.otter.canal.common.AbstractCanalLifeCycle;
import com.alibaba.otter.canal.common.alarm.CanalAlarmHandler;
import com.alibaba.otter.canal.filter.CanalEventFilter;
import com.alibaba.otter.canal.filter.aviater.AviaterRegexFilter;
import com.alibaba.otter.canal.instance.core.CanalInstance;
import com.alibaba.otter.canal.meta.CanalMetaManager;
import com.alibaba.otter.canal.parse.CanalEventParser;
import com.alibaba.otter.canal.parse.CanalHASwitchable;
import com.alibaba.otter.canal.parse.ha.CanalHAController;
import com.alibaba.otter.canal.parse.ha.HeartBeatHAController;
import com.alibaba.otter.canal.parse.inbound.AbstractEventParser;
import com.alibaba.otter.canal.parse.inbound.group.GroupEventParser;
import com.alibaba.otter.canal.parse.inbound.mysql.MysqlEventParser;
import com.alibaba.otter.canal.parse.index.CanalLogPositionManager;
import com.alibaba.otter.canal.protocol.CanalEntry;
import com.alibaba.otter.canal.protocol.ClientIdentity;
import com.alibaba.otter.canal.sink.CanalEventSink;
import com.alibaba.otter.canal.store.CanalEventStore;
import com.alibaba.otter.canal.store.model.Event;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractCanalInstance
extends AbstractCanalLifeCycle
implements CanalInstance {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCanalInstance.class);
    protected Long canalId;
    protected String destination;
    protected CanalEventStore<Event> eventStore;
    protected CanalEventParser eventParser;
    protected CanalEventSink<List<CanalEntry.Entry>> eventSink;
    protected CanalMetaManager metaManager;
    protected CanalAlarmHandler alarmHandler;

    @Override
    public boolean subscribeChange(ClientIdentity identity) {
        if (StringUtils.isNotEmpty((String)identity.getFilter())) {
            logger.info("subscribe filter change to " + identity.getFilter());
            AviaterRegexFilter aviaterFilter = new AviaterRegexFilter(identity.getFilter());
            boolean isGroup = this.eventParser instanceof GroupEventParser;
            if (isGroup) {
                List eventParsers = ((GroupEventParser)this.eventParser).getEventParsers();
                for (CanalEventParser singleEventParser : eventParsers) {
                    ((AbstractEventParser)singleEventParser).setEventFilter((CanalEventFilter)aviaterFilter);
                }
            } else {
                ((AbstractEventParser)this.eventParser).setEventFilter((CanalEventFilter)aviaterFilter);
            }
        }
        return true;
    }

    public void start() {
        super.start();
        if (!this.metaManager.isStart()) {
            this.metaManager.start();
        }
        if (!this.alarmHandler.isStart()) {
            this.alarmHandler.start();
        }
        if (!this.eventStore.isStart()) {
            this.eventStore.start();
        }
        if (!this.eventSink.isStart()) {
            this.eventSink.start();
        }
        if (!this.eventParser.isStart()) {
            this.beforeStartEventParser(this.eventParser);
            this.eventParser.start();
            this.afterStartEventParser(this.eventParser);
        }
        logger.info("start successful....");
    }

    public void stop() {
        super.stop();
        logger.info("stop CannalInstance for {}-{} ", new Object[]{this.canalId, this.destination});
        if (this.eventParser.isStart()) {
            this.beforeStopEventParser(this.eventParser);
            this.eventParser.stop();
            this.afterStopEventParser(this.eventParser);
        }
        if (this.eventSink.isStart()) {
            this.eventSink.stop();
        }
        if (this.eventStore.isStart()) {
            this.eventStore.stop();
        }
        if (this.metaManager.isStart()) {
            this.metaManager.stop();
        }
        if (this.alarmHandler.isStart()) {
            this.alarmHandler.stop();
        }
        logger.info("stop successful....");
    }

    protected void beforeStartEventParser(CanalEventParser eventParser) {
        boolean isGroup = eventParser instanceof GroupEventParser;
        if (isGroup) {
            List eventParsers = ((GroupEventParser)eventParser).getEventParsers();
            for (CanalEventParser singleEventParser : eventParsers) {
                this.startEventParserInternal(singleEventParser, true);
            }
        } else {
            this.startEventParserInternal(eventParser, false);
        }
    }

    protected void afterStartEventParser(CanalEventParser eventParser) {
        List clientIdentitys = this.metaManager.listAllSubscribeInfo(this.destination);
        for (ClientIdentity clientIdentity : clientIdentitys) {
            this.subscribeChange(clientIdentity);
        }
    }

    protected void beforeStopEventParser(CanalEventParser eventParser) {
    }

    protected void afterStopEventParser(CanalEventParser eventParser) {
        boolean isGroup = eventParser instanceof GroupEventParser;
        if (isGroup) {
            List eventParsers = ((GroupEventParser)eventParser).getEventParsers();
            for (CanalEventParser singleEventParser : eventParsers) {
                this.stopEventParserInternal(singleEventParser);
            }
        } else {
            this.stopEventParserInternal(eventParser);
        }
    }

    protected void startEventParserInternal(CanalEventParser eventParser, boolean isGroup) {
        AbstractEventParser abstractEventParser;
        CanalLogPositionManager logPositionManager;
        if (eventParser instanceof AbstractEventParser && !(logPositionManager = (abstractEventParser = (AbstractEventParser)eventParser).getLogPositionManager()).isStart()) {
            logPositionManager.start();
        }
        if (eventParser instanceof MysqlEventParser) {
            MysqlEventParser mysqlEventParser = (MysqlEventParser)eventParser;
            CanalHAController haController = mysqlEventParser.getHaController();
            if (haController instanceof HeartBeatHAController) {
                ((HeartBeatHAController)haController).setCanalHASwitchable((CanalHASwitchable)mysqlEventParser);
            }
            if (!haController.isStart()) {
                haController.start();
            }
        }
    }

    protected void stopEventParserInternal(CanalEventParser eventParser) {
        MysqlEventParser mysqlEventParser;
        CanalHAController haController;
        AbstractEventParser abstractEventParser;
        CanalLogPositionManager logPositionManager;
        if (eventParser instanceof AbstractEventParser && (logPositionManager = (abstractEventParser = (AbstractEventParser)eventParser).getLogPositionManager()).isStart()) {
            logPositionManager.stop();
        }
        if (eventParser instanceof MysqlEventParser && (haController = (mysqlEventParser = (MysqlEventParser)eventParser).getHaController()).isStart()) {
            haController.stop();
        }
    }

    @Override
    public String getDestination() {
        return this.destination;
    }

    @Override
    public CanalEventParser getEventParser() {
        return this.eventParser;
    }

    @Override
    public CanalEventSink getEventSink() {
        return this.eventSink;
    }

    @Override
    public CanalEventStore getEventStore() {
        return this.eventStore;
    }

    @Override
    public CanalMetaManager getMetaManager() {
        return this.metaManager;
    }

    @Override
    public CanalAlarmHandler getAlarmHandler() {
        return this.alarmHandler;
    }
}

