/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.meta;

import com.alibaba.otter.canal.common.AbstractCanalLifeCycle;
import com.alibaba.otter.canal.meta.CanalMetaManager;
import com.alibaba.otter.canal.meta.exception.CanalMetaManagerException;
import com.alibaba.otter.canal.protocol.ClientIdentity;
import com.alibaba.otter.canal.protocol.position.Position;
import com.alibaba.otter.canal.protocol.position.PositionRange;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.MigrateMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class MemoryMetaManager
extends AbstractCanalLifeCycle
implements CanalMetaManager {
    protected Map<String, List<ClientIdentity>> destinations;
    protected Map<ClientIdentity, MemoryClientIdentityBatch> batches;
    protected Map<ClientIdentity, Position> cursors;

    public void start() {
        super.start();
        this.batches = MigrateMap.makeComputingMap((Function)new Function<ClientIdentity, MemoryClientIdentityBatch>(){

            public MemoryClientIdentityBatch apply(ClientIdentity clientIdentity) {
                return MemoryClientIdentityBatch.create(clientIdentity);
            }
        });
        this.cursors = new MapMaker().makeMap();
        this.destinations = MigrateMap.makeComputingMap((Function)new Function<String, List<ClientIdentity>>(){

            public List<ClientIdentity> apply(String destination) {
                return Lists.newArrayList();
            }
        });
    }

    public void stop() {
        super.stop();
        this.destinations.clear();
        this.cursors.clear();
        for (MemoryClientIdentityBatch batch : this.batches.values()) {
            batch.clearPositionRanges();
        }
    }

    @Override
    public synchronized void subscribe(ClientIdentity clientIdentity) throws CanalMetaManagerException {
        List<ClientIdentity> clientIdentitys = this.destinations.get(clientIdentity.getDestination());
        if (clientIdentitys.contains(clientIdentity)) {
            clientIdentitys.remove(clientIdentity);
        }
        clientIdentitys.add(clientIdentity);
    }

    @Override
    public synchronized boolean hasSubscribe(ClientIdentity clientIdentity) throws CanalMetaManagerException {
        List<ClientIdentity> clientIdentitys = this.destinations.get(clientIdentity.getDestination());
        return clientIdentitys != null && clientIdentitys.contains(clientIdentity);
    }

    @Override
    public synchronized void unsubscribe(ClientIdentity clientIdentity) throws CanalMetaManagerException {
        List<ClientIdentity> clientIdentitys = this.destinations.get(clientIdentity.getDestination());
        if (clientIdentitys != null && clientIdentitys.contains(clientIdentity)) {
            clientIdentitys.remove(clientIdentity);
        }
    }

    @Override
    public synchronized List<ClientIdentity> listAllSubscribeInfo(String destination) throws CanalMetaManagerException {
        return this.destinations.get(destination);
    }

    @Override
    public Position getCursor(ClientIdentity clientIdentity) throws CanalMetaManagerException {
        return this.cursors.get(clientIdentity);
    }

    @Override
    public void updateCursor(ClientIdentity clientIdentity, Position position) throws CanalMetaManagerException {
        this.cursors.put(clientIdentity, position);
    }

    @Override
    public Long addBatch(ClientIdentity clientIdentity, PositionRange positionRange) throws CanalMetaManagerException {
        return this.batches.get(clientIdentity).addPositionRange(positionRange);
    }

    @Override
    public void addBatch(ClientIdentity clientIdentity, PositionRange positionRange, Long batchId) throws CanalMetaManagerException {
        this.batches.get(clientIdentity).addPositionRange(positionRange, batchId);
    }

    @Override
    public PositionRange removeBatch(ClientIdentity clientIdentity, Long batchId) throws CanalMetaManagerException {
        return this.batches.get(clientIdentity).removePositionRange(batchId);
    }

    @Override
    public PositionRange getBatch(ClientIdentity clientIdentity, Long batchId) throws CanalMetaManagerException {
        return this.batches.get(clientIdentity).getPositionRange(batchId);
    }

    @Override
    public PositionRange getLastestBatch(ClientIdentity clientIdentity) throws CanalMetaManagerException {
        return this.batches.get(clientIdentity).getLastestPositionRange();
    }

    @Override
    public PositionRange getFirstBatch(ClientIdentity clientIdentity) throws CanalMetaManagerException {
        return this.batches.get(clientIdentity).getFirstPositionRange();
    }

    @Override
    public Map<Long, PositionRange> listAllBatchs(ClientIdentity clientIdentity) throws CanalMetaManagerException {
        return this.batches.get(clientIdentity).listAllPositionRange();
    }

    @Override
    public void clearAllBatchs(ClientIdentity clientIdentity) throws CanalMetaManagerException {
        this.batches.get(clientIdentity).clearPositionRanges();
    }

    public static class MemoryClientIdentityBatch {
        private ClientIdentity clientIdentity;
        private Map<Long, PositionRange> batches = new MapMaker().makeMap();
        private AtomicLong atomicMaxBatchId = new AtomicLong(1L);

        public static MemoryClientIdentityBatch create(ClientIdentity clientIdentity) {
            return new MemoryClientIdentityBatch(clientIdentity);
        }

        public MemoryClientIdentityBatch() {
        }

        protected MemoryClientIdentityBatch(ClientIdentity clientIdentity) {
            this.clientIdentity = clientIdentity;
        }

        public synchronized void addPositionRange(PositionRange positionRange, Long batchId) {
            this.updateMaxId(batchId);
            this.batches.put(batchId, positionRange);
        }

        public synchronized Long addPositionRange(PositionRange positionRange) {
            Long batchId = this.atomicMaxBatchId.getAndIncrement();
            this.batches.put(batchId, positionRange);
            return batchId;
        }

        public synchronized PositionRange removePositionRange(Long batchId) {
            if (this.batches.containsKey(batchId)) {
                Long minBatchId = Collections.min(this.batches.keySet());
                if (!minBatchId.equals(batchId)) {
                    throw new CanalMetaManagerException(String.format("batchId:%d is not the firstly:%d", batchId, minBatchId));
                }
                return this.batches.remove(batchId);
            }
            return null;
        }

        public synchronized PositionRange getPositionRange(Long batchId) {
            return this.batches.get(batchId);
        }

        public synchronized PositionRange getLastestPositionRange() {
            if (this.batches.size() == 0) {
                return null;
            }
            Long batchId = Collections.max(this.batches.keySet());
            return this.batches.get(batchId);
        }

        public synchronized PositionRange getFirstPositionRange() {
            if (this.batches.size() == 0) {
                return null;
            }
            Long batchId = Collections.min(this.batches.keySet());
            return this.batches.get(batchId);
        }

        public synchronized Map<Long, PositionRange> listAllPositionRange() {
            Set<Long> batchIdSets = this.batches.keySet();
            ArrayList batchIds = Lists.newArrayList(batchIdSets);
            Collections.sort(Lists.newArrayList((Iterable)batchIds));
            return Maps.newHashMap(this.batches);
        }

        public synchronized void clearPositionRanges() {
            this.batches.clear();
        }

        private synchronized void updateMaxId(Long batchId) {
            if (this.atomicMaxBatchId.get() < batchId + 1L) {
                this.atomicMaxBatchId.set(batchId + 1L);
            }
        }

        public ClientIdentity getClientIdentity() {
            return this.clientIdentity;
        }

        public void setClientIdentity(ClientIdentity clientIdentity) {
            this.clientIdentity = clientIdentity;
        }
    }
}

