/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql;

import com.alibaba.otter.canal.parse.CanalEventParser;
import com.alibaba.otter.canal.parse.exception.CanalParseException;
import com.alibaba.otter.canal.parse.inbound.ErosaConnection;
import com.alibaba.otter.canal.parse.inbound.mysql.AbstractMysqlEventParser;
import com.alibaba.otter.canal.parse.inbound.mysql.LocalBinLogConnection;
import com.alibaba.otter.canal.parse.index.CanalLogPositionManager;
import com.alibaba.otter.canal.parse.support.AuthenticationInfo;
import com.alibaba.otter.canal.protocol.position.EntryPosition;
import com.alibaba.otter.canal.protocol.position.LogPosition;
import org.apache.commons.lang.StringUtils;

public class LocalBinlogEventParser
extends AbstractMysqlEventParser
implements CanalEventParser {
    private AuthenticationInfo masterInfo;
    private EntryPosition masterPosition;
    private String directory;
    private boolean needWait = false;
    private int bufferSize = 16384;

    @Override
    protected ErosaConnection buildErosaConnection() {
        return this.buildLocalBinLogConnection();
    }

    @Override
    public void start() throws CanalParseException {
        if (this.runningInfo == null) {
            this.runningInfo = this.masterInfo;
        }
        super.start();
    }

    private ErosaConnection buildLocalBinLogConnection() {
        LocalBinLogConnection connection = new LocalBinLogConnection();
        connection.setBufferSize(this.bufferSize);
        connection.setDirectory(this.directory);
        connection.setNeedWait(this.needWait);
        return connection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected EntryPosition findStartPosition(ErosaConnection connection) {
        LogPosition logPosition = this.logPositionManager.getLatestIndexBy(this.destination);
        if (logPosition != null) return logPosition.getPostion();
        EntryPosition entryPosition = this.masterPosition;
        if (StringUtils.isEmpty((String)entryPosition.getJournalName())) {
            if (entryPosition.getTimestamp() == null) return null;
            return new EntryPosition(entryPosition.getTimestamp());
        }
        if (entryPosition.getPosition() == null) return new EntryPosition(entryPosition.getTimestamp());
        return entryPosition;
    }

    @Override
    public void setLogPositionManager(CanalLogPositionManager logPositionManager) {
        this.logPositionManager = logPositionManager;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setMasterPosition(EntryPosition masterPosition) {
        this.masterPosition = masterPosition;
    }

    public void setMasterInfo(AuthenticationInfo masterInfo) {
        this.masterInfo = masterInfo;
    }

    public boolean isNeedWait() {
        return this.needWait;
    }

    public void setNeedWait(boolean needWait) {
        this.needWait = needWait;
    }
}

