/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql;

import com.alibaba.otter.canal.parse.driver.mysql.MysqlConnector;
import com.alibaba.otter.canal.parse.driver.mysql.MysqlQueryExecutor;
import com.alibaba.otter.canal.parse.driver.mysql.MysqlUpdateExecutor;
import com.alibaba.otter.canal.parse.driver.mysql.packets.HeaderPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.client.BinlogDumpCommandPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.ResultSetPacket;
import com.alibaba.otter.canal.parse.driver.mysql.utils.PacketManager;
import com.alibaba.otter.canal.parse.exception.CanalParseException;
import com.alibaba.otter.canal.parse.inbound.ErosaConnection;
import com.alibaba.otter.canal.parse.inbound.SinkFunction;
import com.alibaba.otter.canal.parse.inbound.mysql.dbsync.DirectLogFetcher;
import com.taobao.tddl.dbsync.binlog.LogBuffer;
import com.taobao.tddl.dbsync.binlog.LogContext;
import com.taobao.tddl.dbsync.binlog.LogDecoder;
import com.taobao.tddl.dbsync.binlog.LogEvent;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlConnection
implements ErosaConnection {
    private static final Logger logger = LoggerFactory.getLogger(MysqlConnection.class);
    private MysqlConnector connector;
    private long slaveId;
    private Charset charset = Charset.forName("UTF-8");
    private BinlogFormat binlogFormat;
    private BinlogImage binlogImage;

    public MysqlConnection() {
    }

    public MysqlConnection(InetSocketAddress address, String username, String password) {
        this.connector = new MysqlConnector(address, username, password);
    }

    public MysqlConnection(InetSocketAddress address, String username, String password, byte charsetNumber, String defaultSchema) {
        this.connector = new MysqlConnector(address, username, password, charsetNumber, defaultSchema);
    }

    @Override
    public void connect() throws IOException {
        this.connector.connect();
    }

    @Override
    public void reconnect() throws IOException {
        this.connector.reconnect();
    }

    @Override
    public void disconnect() throws IOException {
        this.connector.disconnect();
    }

    @Override
    public boolean isConnected() {
        return this.connector.isConnected();
    }

    public ResultSetPacket query(String cmd) throws IOException {
        MysqlQueryExecutor exector = new MysqlQueryExecutor(this.connector);
        return exector.query(cmd);
    }

    public void update(String cmd) throws IOException {
        MysqlUpdateExecutor exector = new MysqlUpdateExecutor(this.connector);
        exector.update(cmd);
    }

    @Override
    public void seek(String binlogfilename, Long binlogPosition, SinkFunction func) throws IOException {
        this.updateSettings();
        this.sendBinlogDump(binlogfilename, binlogPosition);
        DirectLogFetcher fetcher = new DirectLogFetcher(this.connector.getReceiveBufferSize());
        fetcher.start(this.connector.getChannel());
        LogDecoder decoder = new LogDecoder();
        decoder.handle(4);
        decoder.handle(15);
        decoder.handle(2);
        decoder.handle(16);
        LogContext context = new LogContext();
        while (fetcher.fetch()) {
            LogEvent event = null;
            event = decoder.decode((LogBuffer)fetcher, context);
            if (event == null) {
                throw new CanalParseException("parse failed");
            }
            if (func.sink(event)) continue;
            break;
        }
    }

    @Override
    public void dump(String binlogfilename, Long binlogPosition, SinkFunction func) throws IOException {
        this.updateSettings();
        this.sendBinlogDump(binlogfilename, binlogPosition);
        DirectLogFetcher fetcher = new DirectLogFetcher(this.connector.getReceiveBufferSize());
        fetcher.start(this.connector.getChannel());
        LogDecoder decoder = new LogDecoder(0, 164);
        LogContext context = new LogContext();
        while (fetcher.fetch()) {
            LogEvent event = null;
            event = decoder.decode((LogBuffer)fetcher, context);
            if (event == null) {
                throw new CanalParseException("parse failed");
            }
            if (func.sink(event)) continue;
            break;
        }
    }

    @Override
    public void dump(long timestamp, SinkFunction func) throws IOException {
        throw new NullPointerException("Not implement yet");
    }

    private void sendBinlogDump(String binlogfilename, Long binlogPosition) throws IOException {
        BinlogDumpCommandPacket binlogDumpCmd = new BinlogDumpCommandPacket();
        binlogDumpCmd.binlogFileName = binlogfilename;
        binlogDumpCmd.binlogPosition = binlogPosition;
        binlogDumpCmd.slaveServerId = this.slaveId;
        byte[] cmdBody = binlogDumpCmd.toBytes();
        logger.info("COM_BINLOG_DUMP with position:{}", (Object)binlogDumpCmd);
        HeaderPacket binlogDumpHeader = new HeaderPacket();
        binlogDumpHeader.setPacketBodyLength(cmdBody.length);
        binlogDumpHeader.setPacketSequenceNumber((byte)0);
        PacketManager.write((SocketChannel)this.connector.getChannel(), (ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(binlogDumpHeader.toBytes()), ByteBuffer.wrap(cmdBody)});
        this.connector.setDumping(true);
    }

    @Override
    public MysqlConnection fork() {
        MysqlConnection connection = new MysqlConnection();
        connection.setCharset(this.getCharset());
        connection.setSlaveId(this.getSlaveId());
        connection.setConnector(this.connector.fork());
        return connection;
    }

    private void updateSettings() throws IOException {
        try {
            this.update("set wait_timeout=9999999");
        }
        catch (Exception e) {
            logger.warn(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        try {
            this.update("set net_write_timeout=1800");
        }
        catch (Exception e) {
            logger.warn(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        try {
            this.update("set net_read_timeout=1800");
        }
        catch (Exception e) {
            logger.warn(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        try {
            this.update("set names 'binary'");
        }
        catch (Exception e) {
            logger.warn(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        try {
            this.update("set @master_binlog_checksum= '@@global.binlog_checksum'");
        }
        catch (Exception e) {
            logger.warn(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        try {
            this.update("SET @mariadb_slave_capability='4'");
        }
        catch (Exception e) {
            logger.warn(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
    }

    private void loadBinlogFormat() {
        ResultSetPacket rs = null;
        try {
            rs = this.query("show variables like 'binlog_format'");
        }
        catch (IOException e) {
            throw new CanalParseException(e);
        }
        List columnValues = rs.getFieldValues();
        if (columnValues == null || columnValues.size() != 2) {
            logger.warn("unexpected binlog format query result, this may cause unexpected result, so throw exception to request network to io shutdown.");
            throw new IllegalStateException("unexpected binlog format query result:" + rs.getFieldValues());
        }
        this.binlogFormat = BinlogFormat.valuesOf((String)columnValues.get(1));
        if (this.binlogFormat == null) {
            throw new IllegalStateException("unexpected binlog format query result:" + rs.getFieldValues());
        }
    }

    private void loadBinlogImage() {
        ResultSetPacket rs = null;
        try {
            rs = this.query("show variables like 'binlog_row_image'");
        }
        catch (IOException e) {
            throw new CanalParseException(e);
        }
        List columnValues = rs.getFieldValues();
        this.binlogImage = columnValues == null || columnValues.size() != 2 ? BinlogImage.FULL : BinlogImage.valuesOf((String)columnValues.get(1));
        if (this.binlogFormat == null) {
            throw new IllegalStateException("unexpected binlog image query result:" + rs.getFieldValues());
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public long getSlaveId() {
        return this.slaveId;
    }

    public void setSlaveId(long slaveId) {
        this.slaveId = slaveId;
    }

    public MysqlConnector getConnector() {
        return this.connector;
    }

    public void setConnector(MysqlConnector connector) {
        this.connector = connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinlogFormat getBinlogFormat() {
        if (this.binlogFormat == null) {
            MysqlConnection mysqlConnection = this;
            synchronized (mysqlConnection) {
                this.loadBinlogFormat();
            }
        }
        return this.binlogFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinlogImage getBinlogImage() {
        if (this.binlogImage == null) {
            MysqlConnection mysqlConnection = this;
            synchronized (mysqlConnection) {
                this.loadBinlogImage();
            }
        }
        return this.binlogImage;
    }

    public static enum BinlogImage {
        FULL("FULL"),
        MINIMAL("MINIMAL"),
        NOBLOB("NOBLOB");

        private String value;

        public boolean isFull() {
            return this == FULL;
        }

        public boolean isMinimal() {
            return this == MINIMAL;
        }

        public boolean isNoBlob() {
            return this == NOBLOB;
        }

        private BinlogImage(String value) {
            this.value = value;
        }

        public static BinlogImage valuesOf(String value) {
            BinlogImage[] formats;
            for (BinlogImage format : formats = BinlogImage.values()) {
                if (!format.value.equalsIgnoreCase(value)) continue;
                return format;
            }
            return null;
        }
    }

    public static enum BinlogFormat {
        STATEMENT("STATEMENT"),
        ROW("ROW"),
        MIXED("MIXED");

        private String value;

        public boolean isStatement() {
            return this == STATEMENT;
        }

        public boolean isRow() {
            return this == ROW;
        }

        public boolean isMixed() {
            return this == MIXED;
        }

        private BinlogFormat(String value) {
            this.value = value;
        }

        public static BinlogFormat valuesOf(String value) {
            BinlogFormat[] formats;
            for (BinlogFormat format : formats = BinlogFormat.values()) {
                if (!format.value.equalsIgnoreCase(value)) continue;
                return format;
            }
            return null;
        }
    }
}

