/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql.dbsync;

import com.alibaba.otter.canal.common.AbstractCanalLifeCycle;
import com.alibaba.otter.canal.filter.aviater.AviaterRegexFilter;
import com.alibaba.otter.canal.parse.exception.CanalParseException;
import com.alibaba.otter.canal.parse.exception.TableIdNotFoundException;
import com.alibaba.otter.canal.parse.inbound.BinlogParser;
import com.alibaba.otter.canal.parse.inbound.TableMeta;
import com.alibaba.otter.canal.parse.inbound.mysql.dbsync.SimpleDdlParser;
import com.alibaba.otter.canal.parse.inbound.mysql.dbsync.TableMetaCache;
import com.alibaba.otter.canal.protocol.CanalEntry;
import com.google.protobuf.ByteString;
import com.taobao.tddl.dbsync.binlog.LogEvent;
import com.taobao.tddl.dbsync.binlog.event.DeleteRowsLogEvent;
import com.taobao.tddl.dbsync.binlog.event.IntvarLogEvent;
import com.taobao.tddl.dbsync.binlog.event.LogHeader;
import com.taobao.tddl.dbsync.binlog.event.QueryLogEvent;
import com.taobao.tddl.dbsync.binlog.event.RandLogEvent;
import com.taobao.tddl.dbsync.binlog.event.RotateLogEvent;
import com.taobao.tddl.dbsync.binlog.event.RowsLogBuffer;
import com.taobao.tddl.dbsync.binlog.event.RowsLogEvent;
import com.taobao.tddl.dbsync.binlog.event.RowsQueryLogEvent;
import com.taobao.tddl.dbsync.binlog.event.TableMapLogEvent;
import com.taobao.tddl.dbsync.binlog.event.UnknownLogEvent;
import com.taobao.tddl.dbsync.binlog.event.UpdateRowsLogEvent;
import com.taobao.tddl.dbsync.binlog.event.UserVarLogEvent;
import com.taobao.tddl.dbsync.binlog.event.WriteRowsLogEvent;
import com.taobao.tddl.dbsync.binlog.event.XidLogEvent;
import com.taobao.tddl.dbsync.binlog.event.mariadb.AnnotateRowsEvent;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.BitSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogEventConvert
extends AbstractCanalLifeCycle
implements BinlogParser<LogEvent> {
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static final String UTF_8 = "UTF-8";
    public static final int TINYINT_MAX_VALUE = 256;
    public static final int SMALLINT_MAX_VALUE = 65536;
    public static final int MEDIUMINT_MAX_VALUE = 0x1000000;
    public static final long INTEGER_MAX_VALUE = 0x100000000L;
    public static final BigInteger BIGINT_MAX_VALUE = new BigInteger("18446744073709551616");
    public static final int version = 1;
    public static final String BEGIN = "BEGIN";
    public static final String COMMIT = "COMMIT";
    public static final Logger logger = LoggerFactory.getLogger(LogEventConvert.class);
    private volatile AviaterRegexFilter nameFilter;
    private volatile AviaterRegexFilter nameBlackFilter;
    private TableMetaCache tableMetaCache;
    private String binlogFileName = "mysql-bin.000001";
    private Charset charset = Charset.defaultCharset();
    private boolean filterQueryDcl = false;
    private boolean filterQueryDml = false;
    private boolean filterQueryDdl = false;
    private boolean filterTableError = false;
    private boolean filterRows = false;

    @Override
    public CanalEntry.Entry parse(LogEvent logEvent) throws CanalParseException {
        if (logEvent == null || logEvent instanceof UnknownLogEvent) {
            return null;
        }
        int eventType = logEvent.getHeader().getType();
        switch (eventType) {
            case 4: {
                this.binlogFileName = ((RotateLogEvent)logEvent).getFilename();
                break;
            }
            case 2: {
                return this.parseQueryEvent((QueryLogEvent)logEvent);
            }
            case 16: {
                return this.parseXidEvent((XidLogEvent)logEvent);
            }
            case 19: {
                break;
            }
            case 23: 
            case 30: {
                return this.parseRowsEvent((RowsLogEvent)((WriteRowsLogEvent)logEvent));
            }
            case 24: 
            case 31: {
                return this.parseRowsEvent((RowsLogEvent)((UpdateRowsLogEvent)logEvent));
            }
            case 25: 
            case 32: {
                return this.parseRowsEvent((RowsLogEvent)((DeleteRowsLogEvent)logEvent));
            }
            case 29: {
                return this.parseRowsQueryEvent((RowsQueryLogEvent)logEvent);
            }
            case 160: {
                return this.parseAnnotateRowsEvent((AnnotateRowsEvent)logEvent);
            }
            case 14: {
                return this.parseUserVarLogEvent((UserVarLogEvent)logEvent);
            }
            case 5: {
                return this.parseIntrvarLogEvent((IntvarLogEvent)logEvent);
            }
            case 13: {
                return this.parseRandLogEvent((RandLogEvent)logEvent);
            }
        }
        return null;
    }

    @Override
    public void reset() {
        this.binlogFileName = "mysql-bin.000001";
        if (this.tableMetaCache != null) {
            this.tableMetaCache.clearTableMeta();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CanalEntry.Entry parseQueryEvent(QueryLogEvent event) {
        String queryString = event.getQuery();
        if (StringUtils.endsWithIgnoreCase((String)queryString, (String)BEGIN)) {
            CanalEntry.TransactionBegin transactionBegin = LogEventConvert.createTransactionBegin(event.getSessionId());
            CanalEntry.Header header = this.createHeader(this.binlogFileName, event.getHeader(), "", "", null);
            return LogEventConvert.createEntry(header, CanalEntry.EntryType.TRANSACTIONBEGIN, transactionBegin.toByteString());
        }
        if (StringUtils.endsWithIgnoreCase((String)queryString, (String)COMMIT)) {
            CanalEntry.TransactionEnd transactionEnd = LogEventConvert.createTransactionEnd(0L);
            CanalEntry.Header header = this.createHeader(this.binlogFileName, event.getHeader(), "", "", null);
            return LogEventConvert.createEntry(header, CanalEntry.EntryType.TRANSACTIONEND, transactionEnd.toByteString());
        }
        SimpleDdlParser.DdlResult result = SimpleDdlParser.parse(queryString, event.getDbName());
        String schemaName = event.getDbName();
        if (StringUtils.isNotEmpty((String)result.getSchemaName())) {
            schemaName = result.getSchemaName();
        }
        String tableName = result.getTableName();
        CanalEntry.EventType type = CanalEntry.EventType.QUERY;
        if (result.getType() == CanalEntry.EventType.ALTER || result.getType() == CanalEntry.EventType.ERASE || result.getType() == CanalEntry.EventType.CREATE || result.getType() == CanalEntry.EventType.TRUNCATE || result.getType() == CanalEntry.EventType.RENAME || result.getType() == CanalEntry.EventType.CINDEX || result.getType() == CanalEntry.EventType.DINDEX) {
            if (this.filterQueryDdl) {
                return null;
            }
            type = result.getType();
            if (StringUtils.isEmpty((String)tableName) || result.getType() == CanalEntry.EventType.RENAME && StringUtils.isEmpty((String)result.getOriTableName())) {
                throw new CanalParseException("SimpleDdlParser process query failed. pls submit issue with this queryString: " + queryString + " , and DdlResult: " + result.toString());
            }
            String name = schemaName + "." + tableName;
            if (this.nameFilter != null && !this.nameFilter.filter(name)) {
                if (result.getType() != CanalEntry.EventType.RENAME) return null;
                if (this.nameFilter != null && !this.nameFilter.filter(result.getOriSchemaName() + "." + result.getOriTableName())) {
                    return null;
                }
            }
            if (this.nameBlackFilter != null && this.nameBlackFilter.filter(name)) {
                if (result.getType() != CanalEntry.EventType.RENAME) return null;
                if (this.nameBlackFilter != null && this.nameBlackFilter.filter(result.getOriSchemaName() + "." + result.getOriTableName())) {
                    return null;
                }
            }
        } else if (result.getType() == CanalEntry.EventType.INSERT || result.getType() == CanalEntry.EventType.UPDATE || result.getType() == CanalEntry.EventType.DELETE ? this.filterQueryDml : this.filterQueryDcl) {
            return null;
        }
        if (this.tableMetaCache != null && (result.getType() == CanalEntry.EventType.ALTER || result.getType() == CanalEntry.EventType.ERASE || result.getType() == CanalEntry.EventType.RENAME)) {
            for (SimpleDdlParser.DdlResult renameResult = result; renameResult != null; renameResult = renameResult.getRenameTableResult()) {
                String schemaName0 = event.getDbName();
                if (StringUtils.isNotEmpty((String)renameResult.getSchemaName())) {
                    schemaName0 = renameResult.getSchemaName();
                }
                if (StringUtils.isNotEmpty((String)(tableName = renameResult.getTableName()))) {
                    this.tableMetaCache.clearTableMeta(schemaName0, tableName);
                    continue;
                }
                this.tableMetaCache.clearTableMetaWithSchemaName(schemaName0);
            }
        }
        CanalEntry.Header header = this.createHeader(this.binlogFileName, event.getHeader(), schemaName, tableName, type);
        CanalEntry.RowChange.Builder rowChangeBuider = CanalEntry.RowChange.newBuilder();
        if (result.getType() != CanalEntry.EventType.QUERY) {
            rowChangeBuider.setIsDdl(true);
        }
        rowChangeBuider.setSql(queryString);
        if (StringUtils.isNotEmpty((String)event.getDbName())) {
            rowChangeBuider.setDdlSchemaName(event.getDbName());
        }
        rowChangeBuider.setEventType(result.getType());
        return LogEventConvert.createEntry(header, CanalEntry.EntryType.ROWDATA, rowChangeBuider.build().toByteString());
    }

    private CanalEntry.Entry parseRowsQueryEvent(RowsQueryLogEvent event) {
        if (this.filterQueryDml) {
            return null;
        }
        String queryString = null;
        try {
            queryString = new String(event.getRowsQuery().getBytes(ISO_8859_1), this.charset.name());
            return this.buildQueryEntry(queryString, event.getHeader());
        }
        catch (UnsupportedEncodingException e) {
            throw new CanalParseException(e);
        }
    }

    private CanalEntry.Entry parseAnnotateRowsEvent(AnnotateRowsEvent event) {
        if (this.filterQueryDml) {
            return null;
        }
        String queryString = null;
        try {
            queryString = new String(event.getRowsQuery().getBytes(ISO_8859_1), this.charset.name());
            return this.buildQueryEntry(queryString, event.getHeader());
        }
        catch (UnsupportedEncodingException e) {
            throw new CanalParseException(e);
        }
    }

    private CanalEntry.Entry parseUserVarLogEvent(UserVarLogEvent event) {
        if (this.filterQueryDml) {
            return null;
        }
        return this.buildQueryEntry(event.getQuery(), event.getHeader());
    }

    private CanalEntry.Entry parseIntrvarLogEvent(IntvarLogEvent event) {
        if (this.filterQueryDml) {
            return null;
        }
        return this.buildQueryEntry(event.getQuery(), event.getHeader());
    }

    private CanalEntry.Entry parseRandLogEvent(RandLogEvent event) {
        if (this.filterQueryDml) {
            return null;
        }
        return this.buildQueryEntry(event.getQuery(), event.getHeader());
    }

    private CanalEntry.Entry parseXidEvent(XidLogEvent event) {
        CanalEntry.TransactionEnd transactionEnd = LogEventConvert.createTransactionEnd(event.getXid());
        CanalEntry.Header header = this.createHeader(this.binlogFileName, event.getHeader(), "", "", null);
        return LogEventConvert.createEntry(header, CanalEntry.EntryType.TRANSACTIONEND, transactionEnd.toByteString());
    }

    private CanalEntry.Entry parseRowsEvent(RowsLogEvent event) {
        if (this.filterRows) {
            return null;
        }
        try {
            TableMapLogEvent table = event.getTable();
            if (table == null) {
                throw new TableIdNotFoundException("not found tableId:" + event.getTableId());
            }
            String fullname = table.getDbName() + "." + table.getTableName();
            if (this.nameFilter != null && !this.nameFilter.filter(fullname)) {
                return null;
            }
            if (this.nameBlackFilter != null && this.nameBlackFilter.filter(fullname)) {
                return null;
            }
            CanalEntry.EventType eventType = null;
            int type = event.getHeader().getType();
            if (23 == type || 30 == type) {
                eventType = CanalEntry.EventType.INSERT;
            } else if (24 == type || 31 == type) {
                eventType = CanalEntry.EventType.UPDATE;
            } else if (25 == type || 32 == type) {
                eventType = CanalEntry.EventType.DELETE;
            } else {
                throw new CanalParseException("unsupport event type :" + event.getHeader().getType());
            }
            CanalEntry.Header header = this.createHeader(this.binlogFileName, event.getHeader(), table.getDbName(), table.getTableName(), eventType);
            CanalEntry.RowChange.Builder rowChangeBuider = CanalEntry.RowChange.newBuilder();
            rowChangeBuider.setTableId(event.getTableId());
            rowChangeBuider.setIsDdl(false);
            rowChangeBuider.setEventType(eventType);
            RowsLogBuffer buffer = event.getRowsBuf(this.charset.name());
            BitSet columns = event.getColumns();
            BitSet changeColumns = event.getChangeColumns();
            boolean tableError = false;
            TableMeta tableMeta = null;
            if (this.tableMetaCache != null && (tableMeta = this.getTableMeta(table.getDbName(), table.getTableName(), true)) == null) {
                tableError = true;
                if (!this.filterTableError) {
                    throw new CanalParseException("not found [" + fullname + "] in db , pls check!");
                }
            }
            while (buffer.nextOneRow(columns)) {
                CanalEntry.RowData.Builder rowDataBuilder = CanalEntry.RowData.newBuilder();
                if (CanalEntry.EventType.INSERT == eventType) {
                    tableError |= this.parseOneRow(rowDataBuilder, event, buffer, columns, true, tableMeta);
                } else if (CanalEntry.EventType.DELETE == eventType) {
                    tableError |= this.parseOneRow(rowDataBuilder, event, buffer, columns, false, tableMeta);
                } else {
                    tableError |= this.parseOneRow(rowDataBuilder, event, buffer, columns, false, tableMeta);
                    if (!buffer.nextOneRow(changeColumns)) {
                        rowChangeBuider.addRowDatas(rowDataBuilder.build());
                        break;
                    }
                    tableError |= this.parseOneRow(rowDataBuilder, event, buffer, changeColumns, true, tableMeta);
                }
                rowChangeBuider.addRowDatas(rowDataBuilder.build());
            }
            CanalEntry.RowChange rowChange = rowChangeBuider.build();
            if (tableError) {
                CanalEntry.Entry entry = LogEventConvert.createEntry(header, CanalEntry.EntryType.ROWDATA, ByteString.EMPTY);
                logger.warn("table parser error : {}storeValue: {}", (Object)entry.toString(), (Object)rowChange.toString());
                return null;
            }
            CanalEntry.Entry entry = LogEventConvert.createEntry(header, CanalEntry.EntryType.ROWDATA, rowChangeBuider.build().toByteString());
            return entry;
        }
        catch (Exception e) {
            throw new CanalParseException("parse row data failed.", e);
        }
    }

    private boolean parseOneRow(CanalEntry.RowData.Builder rowDataBuilder, RowsLogEvent event, RowsLogBuffer buffer, BitSet cols, boolean isAfter, TableMeta tableMeta) throws UnsupportedEncodingException {
        int columnCnt = event.getTable().getColumnCnt();
        TableMapLogEvent.ColumnInfo[] columnInfo = event.getTable().getColumnInfo();
        boolean tableError = false;
        if (tableMeta != null && columnInfo.length > tableMeta.getFileds().size()) {
            tableMeta = this.getTableMeta(event.getTable().getDbName(), event.getTable().getTableName(), false);
            if (tableMeta == null) {
                tableError = true;
                if (!this.filterTableError) {
                    throw new CanalParseException("not found [" + event.getTable().getDbName() + "." + event.getTable().getTableName() + "] in db , pls check!");
                }
            }
            if (tableMeta != null && columnInfo.length > tableMeta.getFileds().size()) {
                tableError = true;
                if (!this.filterTableError) {
                    throw new CanalParseException("column size is not match for table:" + tableMeta.getFullName() + "," + columnInfo.length + " vs " + tableMeta.getFileds().size());
                }
            }
        }
        for (int i = 0; i < columnCnt; ++i) {
            TableMapLogEvent.ColumnInfo info = columnInfo[i];
            if (!cols.get(i)) continue;
            CanalEntry.Column.Builder columnBuilder = CanalEntry.Column.newBuilder();
            TableMeta.FieldMeta fieldMeta = null;
            if (tableMeta != null && !tableError) {
                fieldMeta = tableMeta.getFileds().get(i);
                columnBuilder.setName(fieldMeta.getColumnName());
                columnBuilder.setIsKey(fieldMeta.isKey());
                columnBuilder.setMysqlType(fieldMeta.getColumnType());
            }
            columnBuilder.setIndex(i);
            columnBuilder.setIsNull(false);
            boolean isBinary = false;
            if (fieldMeta != null) {
                if (StringUtils.containsIgnoreCase((String)fieldMeta.getColumnType(), (String)"VARBINARY")) {
                    isBinary = true;
                } else if (StringUtils.containsIgnoreCase((String)fieldMeta.getColumnType(), (String)"BINARY")) {
                    isBinary = true;
                }
            }
            buffer.nextValue(info.type, info.meta, isBinary);
            int javaType = buffer.getJavaType();
            if (buffer.isNull()) {
                columnBuilder.setIsNull(true);
            } else {
                Serializable value = buffer.getValue();
                switch (javaType) {
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        Number number = (Number)value;
                        if (fieldMeta != null && fieldMeta.isUnsigned() && number.longValue() < 0L) {
                            switch (buffer.getLength()) {
                                case 1: {
                                    columnBuilder.setValue(String.valueOf((Object)(256 + number.intValue())));
                                    javaType = 5;
                                    break;
                                }
                                case 2: {
                                    columnBuilder.setValue(String.valueOf((Object)(65536 + number.intValue())));
                                    javaType = 4;
                                    break;
                                }
                                case 3: {
                                    columnBuilder.setValue(String.valueOf((Object)(0x1000000 + number.intValue())));
                                    javaType = 4;
                                    break;
                                }
                                case 4: {
                                    columnBuilder.setValue(String.valueOf((Object)(0x100000000L + number.longValue())));
                                    javaType = -5;
                                    break;
                                }
                                case 8: {
                                    columnBuilder.setValue(BIGINT_MAX_VALUE.add(BigInteger.valueOf(number.longValue())).toString());
                                    javaType = 3;
                                }
                            }
                            break;
                        }
                        columnBuilder.setValue(String.valueOf(value));
                        break;
                    }
                    case 7: 
                    case 8: {
                        columnBuilder.setValue(String.valueOf(value));
                        break;
                    }
                    case -7: {
                        columnBuilder.setValue(String.valueOf(value));
                        break;
                    }
                    case 3: {
                        columnBuilder.setValue(((BigDecimal)value).toPlainString());
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        columnBuilder.setValue(value.toString());
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        if (fieldMeta != null && this.isText(fieldMeta.getColumnType())) {
                            columnBuilder.setValue(new String((byte[])value, this.charset));
                            javaType = 2005;
                            break;
                        }
                        columnBuilder.setValue(new String((byte[])value, ISO_8859_1));
                        javaType = 2004;
                        break;
                    }
                    case 1: 
                    case 12: {
                        columnBuilder.setValue(value.toString());
                        break;
                    }
                    default: {
                        columnBuilder.setValue(value.toString());
                    }
                }
            }
            columnBuilder.setSqlType(javaType);
            columnBuilder.setUpdated(isAfter && this.isUpdate(rowDataBuilder.getBeforeColumnsList(), columnBuilder.getIsNull() ? null : columnBuilder.getValue(), i));
            if (isAfter) {
                rowDataBuilder.addAfterColumns(columnBuilder.build());
                continue;
            }
            rowDataBuilder.addBeforeColumns(columnBuilder.build());
        }
        return tableError;
    }

    private CanalEntry.Entry buildQueryEntry(String queryString, LogHeader logHeader) {
        CanalEntry.Header header = this.createHeader(this.binlogFileName, logHeader, "", "", CanalEntry.EventType.QUERY);
        CanalEntry.RowChange.Builder rowChangeBuider = CanalEntry.RowChange.newBuilder();
        rowChangeBuider.setSql(queryString);
        rowChangeBuider.setEventType(CanalEntry.EventType.QUERY);
        return LogEventConvert.createEntry(header, CanalEntry.EntryType.ROWDATA, rowChangeBuider.build().toByteString());
    }

    private CanalEntry.Header createHeader(String binlogFile, LogHeader logHeader, String schemaName, String tableName, CanalEntry.EventType eventType) {
        CanalEntry.Header.Builder headerBuilder = CanalEntry.Header.newBuilder();
        headerBuilder.setVersion(1);
        headerBuilder.setLogfileName(binlogFile);
        headerBuilder.setLogfileOffset(logHeader.getLogPos() - (long)logHeader.getEventLen());
        headerBuilder.setServerId(logHeader.getServerId());
        headerBuilder.setServerenCode(UTF_8);
        headerBuilder.setExecuteTime(logHeader.getWhen() * 1000L);
        headerBuilder.setSourceType(CanalEntry.Type.MYSQL);
        if (eventType != null) {
            headerBuilder.setEventType(eventType);
        }
        if (schemaName != null) {
            headerBuilder.setSchemaName(schemaName);
        }
        if (tableName != null) {
            headerBuilder.setTableName(tableName);
        }
        headerBuilder.setEventLength((long)logHeader.getEventLen());
        return headerBuilder.build();
    }

    private boolean isUpdate(List<CanalEntry.Column> bfColumns, String newValue, int index) {
        if (bfColumns == null) {
            throw new CanalParseException("ERROR ## the bfColumns is null");
        }
        if (index < 0) {
            return false;
        }
        for (CanalEntry.Column column : bfColumns) {
            if (column.getIndex() != index) continue;
            if (column.getIsNull() && newValue == null) {
                return false;
            }
            if (newValue == null || column.getIsNull() || !column.getValue().equals(newValue)) continue;
            return false;
        }
        return true;
    }

    private TableMeta getTableMeta(String dbName, String tbName, boolean useCache) {
        try {
            return this.tableMetaCache.getTableMeta(dbName, tbName, useCache);
        }
        catch (Exception e) {
            String message = ExceptionUtils.getRootCauseMessage((Throwable)e);
            if (this.filterTableError && StringUtils.contains((String)message, (String)"errorNumber=1146") && StringUtils.contains((String)message, (String)"doesn't exist")) {
                return null;
            }
            throw new CanalParseException(e);
        }
    }

    private boolean isText(String columnType) {
        return "LONGTEXT".equalsIgnoreCase(columnType) || "MEDIUMTEXT".equalsIgnoreCase(columnType) || "TEXT".equalsIgnoreCase(columnType) || "TINYTEXT".equalsIgnoreCase(columnType);
    }

    public static CanalEntry.TransactionBegin createTransactionBegin(long threadId) {
        CanalEntry.TransactionBegin.Builder beginBuilder = CanalEntry.TransactionBegin.newBuilder();
        beginBuilder.setThreadId(threadId);
        return beginBuilder.build();
    }

    public static CanalEntry.TransactionEnd createTransactionEnd(long transactionId) {
        CanalEntry.TransactionEnd.Builder endBuilder = CanalEntry.TransactionEnd.newBuilder();
        endBuilder.setTransactionId(String.valueOf(transactionId));
        return endBuilder.build();
    }

    public static CanalEntry.Pair createSpecialPair(String key, String value) {
        CanalEntry.Pair.Builder pairBuilder = CanalEntry.Pair.newBuilder();
        pairBuilder.setKey(key);
        pairBuilder.setValue(value);
        return pairBuilder.build();
    }

    public static CanalEntry.Entry createEntry(CanalEntry.Header header, CanalEntry.EntryType entryType, ByteString storeValue) {
        CanalEntry.Entry.Builder entryBuilder = CanalEntry.Entry.newBuilder();
        entryBuilder.setHeader(header);
        entryBuilder.setEntryType(entryType);
        entryBuilder.setStoreValue(storeValue);
        return entryBuilder.build();
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setNameFilter(AviaterRegexFilter nameFilter) {
        this.nameFilter = nameFilter;
    }

    public void setNameBlackFilter(AviaterRegexFilter nameBlackFilter) {
        this.nameBlackFilter = nameBlackFilter;
    }

    public void setTableMetaCache(TableMetaCache tableMetaCache) {
        this.tableMetaCache = tableMetaCache;
    }

    public void setFilterQueryDcl(boolean filterQueryDcl) {
        this.filterQueryDcl = filterQueryDcl;
    }

    public void setFilterQueryDml(boolean filterQueryDml) {
        this.filterQueryDml = filterQueryDml;
    }

    public void setFilterQueryDdl(boolean filterQueryDdl) {
        this.filterQueryDdl = filterQueryDdl;
    }

    public void setFilterTableError(boolean filterTableError) {
        this.filterTableError = filterTableError;
    }

    public void setFilterRows(boolean filterRows) {
        this.filterRows = filterRows;
    }
}

