/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql.dbsync;

import com.alibaba.otter.canal.parse.driver.mysql.packets.server.FieldPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.ResultSetPacket;
import com.alibaba.otter.canal.parse.exception.CanalParseException;
import com.alibaba.otter.canal.parse.inbound.TableMeta;
import com.alibaba.otter.canal.parse.inbound.mysql.MysqlConnection;
import com.google.common.base.Function;
import com.google.common.collect.MigrateMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TableMetaCache {
    public static final String COLUMN_NAME = "COLUMN_NAME";
    public static final String COLUMN_TYPE = "COLUMN_TYPE";
    public static final String IS_NULLABLE = "IS_NULLABLE";
    public static final String COLUMN_KEY = "COLUMN_KEY";
    public static final String COLUMN_DEFAULT = "COLUMN_DEFAULT";
    public static final String EXTRA = "EXTRA";
    private MysqlConnection connection;
    private Map<String, TableMeta> tableMetaCache;

    public TableMetaCache(MysqlConnection con) {
        this.connection = con;
        this.tableMetaCache = MigrateMap.makeComputingMap((Function)new Function<String, TableMeta>(){

            public TableMeta apply(String name) {
                try {
                    return TableMetaCache.this.getTableMeta0(name);
                }
                catch (IOException e) {
                    try {
                        TableMetaCache.this.connection.reconnect();
                        return TableMetaCache.this.getTableMeta0(name);
                    }
                    catch (IOException e1) {
                        throw new CanalParseException("fetch failed by table meta:" + name, e1);
                    }
                }
            }
        });
    }

    public TableMeta getTableMeta(String schema, String table) {
        return this.getTableMeta(schema, table, true);
    }

    public TableMeta getTableMeta(String schema, String table, boolean useCache) {
        if (!useCache) {
            this.tableMetaCache.remove(this.getFullName(schema, table));
        }
        return this.tableMetaCache.get(this.getFullName(schema, table));
    }

    public void clearTableMeta(String schema, String table) {
        this.tableMetaCache.remove(this.getFullName(schema, table));
    }

    public void clearTableMetaWithSchemaName(String schema) {
        for (String name : this.tableMetaCache.keySet()) {
            if (!StringUtils.startsWithIgnoreCase((String)name, (String)(schema + "."))) continue;
            this.tableMetaCache.remove(name);
        }
    }

    public void clearTableMeta() {
        this.tableMetaCache.clear();
    }

    private TableMeta getTableMeta0(String fullname) throws IOException {
        ResultSetPacket packet = this.connection.query("desc " + fullname);
        return new TableMeta(fullname, this.parserTableMeta(packet));
    }

    private List<TableMeta.FieldMeta> parserTableMeta(ResultSetPacket packet) {
        HashMap<String, Integer> nameMaps = new HashMap<String, Integer>(6, 1.0f);
        int index = 0;
        for (FieldPacket fieldPacket : packet.getFieldDescriptors()) {
            nameMaps.put(fieldPacket.getOriginalName(), index++);
        }
        int size = packet.getFieldDescriptors().size();
        int count = packet.getFieldValues().size() / packet.getFieldDescriptors().size();
        ArrayList<TableMeta.FieldMeta> result = new ArrayList<TableMeta.FieldMeta>();
        for (int i = 0; i < count; ++i) {
            TableMeta.FieldMeta meta = new TableMeta.FieldMeta();
            meta.setColumnName(((String)packet.getFieldValues().get((Integer)nameMaps.get(COLUMN_NAME) + i * size)).intern());
            meta.setColumnType((String)packet.getFieldValues().get((Integer)nameMaps.get(COLUMN_TYPE) + i * size));
            meta.setIsNullable((String)packet.getFieldValues().get((Integer)nameMaps.get(IS_NULLABLE) + i * size));
            meta.setIskey((String)packet.getFieldValues().get((Integer)nameMaps.get(COLUMN_KEY) + i * size));
            meta.setDefaultValue((String)packet.getFieldValues().get((Integer)nameMaps.get(COLUMN_DEFAULT) + i * size));
            meta.setExtra((String)packet.getFieldValues().get((Integer)nameMaps.get(EXTRA) + i * size));
            result.add(meta);
        }
        return result;
    }

    private String getFullName(String schema, String table) {
        StringBuilder builder = new StringBuilder();
        return builder.append('`').append(schema).append('`').append('.').append('`').append(table).append('`').toString();
    }
}

