/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.index;

import com.alibaba.otter.canal.common.AbstractCanalLifeCycle;
import com.alibaba.otter.canal.parse.exception.CanalParseException;
import com.alibaba.otter.canal.parse.index.CanalLogPositionManager;
import com.alibaba.otter.canal.protocol.position.LogPosition;
import org.springframework.util.Assert;

public class FailbackLogPositionManager
extends AbstractCanalLifeCycle
implements CanalLogPositionManager {
    private CanalLogPositionManager primary;
    private CanalLogPositionManager failback;

    public void start() {
        super.start();
        Assert.notNull((Object)this.primary);
        Assert.notNull((Object)this.failback);
        if (!this.primary.isStart()) {
            this.primary.start();
        }
        if (!this.failback.isStart()) {
            this.failback.start();
        }
    }

    public void stop() {
        super.stop();
        if (this.primary.isStart()) {
            this.primary.stop();
        }
        if (this.failback.isStart()) {
            this.failback.stop();
        }
    }

    @Override
    public LogPosition getLatestIndexBy(String destination) {
        LogPosition logPosition = this.primary.getLatestIndexBy(destination);
        if (logPosition == null) {
            return this.failback.getLatestIndexBy(destination);
        }
        return logPosition;
    }

    @Override
    public void persistLogPosition(String destination, LogPosition logPosition) throws CanalParseException {
        try {
            this.primary.persistLogPosition(destination, logPosition);
        }
        catch (CanalParseException e) {
            this.failback.persistLogPosition(destination, logPosition);
        }
    }

    public void setPrimary(CanalLogPositionManager primary) {
        this.primary = primary;
    }

    public void setFailback(CanalLogPositionManager failback) {
        this.failback = failback;
    }
}

