/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.index;

import com.alibaba.otter.canal.common.utils.JsonUtils;
import com.alibaba.otter.canal.meta.exception.CanalMetaManagerException;
import com.alibaba.otter.canal.parse.index.MemoryLogPositionManager;
import com.alibaba.otter.canal.protocol.position.LogPosition;
import com.google.common.base.Function;
import com.google.common.collect.MigrateMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class FileMixedLogPositionManager
extends MemoryLogPositionManager {
    private static final Logger logger = LoggerFactory.getLogger(FileMixedLogPositionManager.class);
    private static final Charset charset = Charset.forName("UTF-8");
    private File dataDir;
    private String dataFileName = "parse.dat";
    private Map<String, File> dataFileCaches;
    private ScheduledExecutorService executor;
    private final LogPosition nullPosition = new LogPosition(){};
    private long period = 1000L;
    private Set<String> persistTasks;

    @Override
    public void start() {
        super.start();
        Assert.notNull((Object)this.dataDir);
        if (!this.dataDir.exists()) {
            try {
                FileUtils.forceMkdir((File)this.dataDir);
            }
            catch (IOException e) {
                throw new CanalMetaManagerException((Throwable)e);
            }
        }
        if (!this.dataDir.canRead() || !this.dataDir.canWrite()) {
            throw new CanalMetaManagerException("dir[" + this.dataDir.getPath() + "] can not read/write");
        }
        this.dataFileCaches = MigrateMap.makeComputingMap((Function)new Function<String, File>(){

            public File apply(String destination) {
                return FileMixedLogPositionManager.this.getDataFile(destination);
            }
        });
        this.executor = Executors.newScheduledThreadPool(1);
        this.positions = MigrateMap.makeComputingMap((Function)new Function<String, LogPosition>(){

            public LogPosition apply(String destination) {
                LogPosition logPosition = FileMixedLogPositionManager.this.loadDataFromFile((File)FileMixedLogPositionManager.this.dataFileCaches.get(destination));
                if (logPosition == null) {
                    return FileMixedLogPositionManager.this.nullPosition;
                }
                return logPosition;
            }
        });
        this.persistTasks = Collections.synchronizedSet(new HashSet());
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ArrayList tasks = new ArrayList(FileMixedLogPositionManager.this.persistTasks);
                for (String destination : tasks) {
                    try {
                        FileMixedLogPositionManager.this.flushDataToFile(destination);
                        FileMixedLogPositionManager.this.persistTasks.remove(destination);
                    }
                    catch (Throwable e) {
                        logger.error("period update" + destination + " curosr failed!", e);
                    }
                }
            }
        }, this.period, this.period, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        super.stop();
        this.flushDataToFile();
        this.executor.shutdownNow();
        this.positions.clear();
    }

    @Override
    public void persistLogPosition(String destination, LogPosition logPosition) {
        this.persistTasks.add(destination);
        super.persistLogPosition(destination, logPosition);
    }

    @Override
    public LogPosition getLatestIndexBy(String destination) {
        LogPosition logPostion = super.getLatestIndexBy(destination);
        if (logPostion == this.nullPosition) {
            return null;
        }
        return logPostion;
    }

    private File getDataFile(String destination) {
        File destinationMetaDir = new File(this.dataDir, destination);
        if (!destinationMetaDir.exists()) {
            try {
                FileUtils.forceMkdir((File)destinationMetaDir);
            }
            catch (IOException e) {
                throw new CanalMetaManagerException((Throwable)e);
            }
        }
        return new File(destinationMetaDir, this.dataFileName);
    }

    private void flushDataToFile() {
        for (String destination : this.positions.keySet()) {
            this.flushDataToFile(destination);
        }
    }

    private void flushDataToFile(String destination) {
        this.flushDataToFile(destination, this.dataFileCaches.get(destination));
    }

    private void flushDataToFile(String destination, File dataFile) {
        LogPosition position = (LogPosition)this.positions.get(destination);
        if (position != null && position != this.nullPosition) {
            String json = JsonUtils.marshalToString((Object)position);
            try {
                FileUtils.writeStringToFile((File)dataFile, (String)json);
            }
            catch (IOException e) {
                throw new CanalMetaManagerException((Throwable)e);
            }
        }
    }

    private LogPosition loadDataFromFile(File dataFile) {
        try {
            if (!dataFile.exists()) {
                return null;
            }
            String json = FileUtils.readFileToString((File)dataFile, (String)charset.name());
            return (LogPosition)JsonUtils.unmarshalFromString((String)json, LogPosition.class);
        }
        catch (IOException e) {
            throw new CanalMetaManagerException((Throwable)e);
        }
    }

    public void setDataDir(String dataDir) {
        this.dataDir = new File(dataDir);
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    public void setPeriod(long period) {
        this.period = period;
    }
}

