/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.index;

import com.alibaba.otter.canal.common.AbstractCanalLifeCycle;
import com.alibaba.otter.canal.meta.CanalMetaManager;
import com.alibaba.otter.canal.parse.index.CanalLogPositionManager;
import com.alibaba.otter.canal.protocol.ClientIdentity;
import com.alibaba.otter.canal.protocol.position.LogPosition;
import com.alibaba.otter.canal.store.helper.CanalEventUtils;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class MetaLogPositionManager
extends AbstractCanalLifeCycle
implements CanalLogPositionManager {
    private static final Logger logger = LoggerFactory.getLogger(MetaLogPositionManager.class);
    private CanalMetaManager metaManager;

    public void start() {
        super.start();
        Assert.notNull((Object)this.metaManager);
        if (!this.metaManager.isStart()) {
            this.metaManager.start();
        }
    }

    public void stop() {
        super.stop();
        if (this.metaManager.isStart()) {
            this.metaManager.stop();
        }
    }

    @Override
    public void persistLogPosition(String destination, LogPosition logPosition) {
        logger.info("persist LogPosition:{}", (Object)destination, (Object)logPosition);
    }

    @Override
    public LogPosition getLatestIndexBy(String destination) {
        List clientIdentitys = this.metaManager.listAllSubscribeInfo(destination);
        LogPosition result = null;
        if (!CollectionUtils.isEmpty((Collection)clientIdentitys)) {
            for (ClientIdentity clientIdentity : clientIdentitys) {
                LogPosition position = (LogPosition)this.metaManager.getCursor(clientIdentity);
                if (position == null) continue;
                if (result == null) {
                    result = position;
                    continue;
                }
                result = CanalEventUtils.min((LogPosition)result, (LogPosition)position);
            }
        }
        return result;
    }

    public void setMetaManager(CanalMetaManager metaManager) {
        this.metaManager = metaManager;
    }
}

