/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.index;

import com.alibaba.otter.canal.common.AbstractCanalLifeCycle;
import com.alibaba.otter.canal.common.utils.JsonUtils;
import com.alibaba.otter.canal.common.zookeeper.ZkClientx;
import com.alibaba.otter.canal.common.zookeeper.ZookeeperPathUtils;
import com.alibaba.otter.canal.parse.index.CanalLogPositionManager;
import com.alibaba.otter.canal.protocol.position.LogPosition;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.springframework.util.Assert;

public class ZooKeeperLogPositionManager
extends AbstractCanalLifeCycle
implements CanalLogPositionManager {
    private ZkClientx zkClientx;

    public void start() {
        super.start();
        Assert.notNull((Object)this.zkClientx);
    }

    public void stop() {
        super.stop();
    }

    @Override
    public LogPosition getLatestIndexBy(String destination) {
        String path = ZookeeperPathUtils.getParsePath((String)destination);
        byte[] data = (byte[])this.zkClientx.readData(path, true);
        if (data == null || data.length == 0) {
            return null;
        }
        return (LogPosition)JsonUtils.unmarshalFromByte((byte[])data, LogPosition.class);
    }

    @Override
    public void persistLogPosition(String destination, LogPosition logPosition) {
        String path = ZookeeperPathUtils.getParsePath((String)destination);
        byte[] data = JsonUtils.marshalToByte((Object)logPosition);
        try {
            this.zkClientx.writeData(path, (Object)data);
        }
        catch (ZkNoNodeException e) {
            this.zkClientx.createPersistent(path, (Object)data, true);
        }
    }

    public void setZkClientx(ZkClientx zkClientx) {
        this.zkClientx = zkClientx;
    }
}

