/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.dbsync.binlog;

import com.taobao.tddl.dbsync.binlog.LogFetcher;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;

public final class FileLogFetcher
extends LogFetcher {
    public static final byte[] BINLOG_MAGIC = new byte[]{-2, 98, 105, 110};
    private FileInputStream fin;

    public FileLogFetcher() {
        super(8192, 2.0f);
    }

    public FileLogFetcher(int initialCapacity) {
        super(initialCapacity, 2.0f);
    }

    public FileLogFetcher(int initialCapacity, float growthFactor) {
        super(initialCapacity, growthFactor);
    }

    public void open(File file) throws FileNotFoundException, IOException {
        this.open(file, 0L);
    }

    public void open(String filePath) throws FileNotFoundException, IOException {
        this.open(new File(filePath), 0L);
    }

    public void open(String filePath, long filePosition) throws FileNotFoundException, IOException {
        this.open(new File(filePath), filePosition);
    }

    public void open(File file, long filePosition) throws FileNotFoundException, IOException {
        this.fin = new FileInputStream(file);
        this.ensureCapacity(4);
        if (4 != this.fin.read(this.buffer, 0, 4)) {
            throw new IOException("No binlog file header");
        }
        if (this.buffer[0] != BINLOG_MAGIC[0] || this.buffer[1] != BINLOG_MAGIC[1] || this.buffer[2] != BINLOG_MAGIC[2] || this.buffer[3] != BINLOG_MAGIC[3]) {
            throw new IOException("Error binlog file header: " + Arrays.toString(Arrays.copyOf(this.buffer, 4)));
        }
        this.limit = 0;
        this.origin = 0;
        this.position = 0;
        if (filePosition > 4L) {
            int maxFormatDescriptionEventLen = 244;
            this.ensureCapacity(244);
            this.limit = this.fin.read(this.buffer, 0, 244);
            this.limit = (int)this.getUint32(9);
            this.fin.getChannel().position(filePosition);
        }
    }

    @Override
    public boolean fetch() throws IOException {
        if (this.limit == 0) {
            int len = this.fin.read(this.buffer, 0, this.buffer.length);
            if (len >= 0) {
                this.limit += len;
                this.position = 0;
                this.origin = 0;
                return true;
            }
        } else if (this.origin == 0) {
            int len;
            if (this.limit > this.buffer.length / 2) {
                this.ensureCapacity(this.buffer.length + this.limit);
            }
            if ((len = this.fin.read(this.buffer, this.limit, this.buffer.length - this.limit)) >= 0) {
                this.limit += len;
                return true;
            }
        } else if (this.limit > 0) {
            System.arraycopy(this.buffer, this.origin, this.buffer, 0, this.limit);
            this.position -= this.origin;
            this.origin = 0;
            int len = this.fin.read(this.buffer, this.limit, this.buffer.length - this.limit);
            if (len >= 0) {
                this.limit += len;
                return true;
            }
        } else {
            throw new IllegalArgumentException("Unexcepted limit: " + this.limit);
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.fin != null) {
            this.fin.close();
        }
        this.fin = null;
    }
}

