/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.driver.mysql;

import com.alibaba.otter.canal.parse.driver.mysql.MysqlUpdateExecutor;
import com.alibaba.otter.canal.parse.driver.mysql.packets.HeaderPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.client.ClientAuthenticationPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.client.QuitCommandPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.ErrorPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.HandshakeInitializationPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.Reply323Packet;
import com.alibaba.otter.canal.parse.driver.mysql.utils.MySQLPasswordEncrypter;
import com.alibaba.otter.canal.parse.driver.mysql.utils.PacketManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlConnector {
    private static final Logger logger = LoggerFactory.getLogger(MysqlConnector.class);
    private InetSocketAddress address;
    private String username;
    private String password;
    private byte charsetNumber = (byte)33;
    private String defaultSchema = "retl";
    private int soTimeout = 30000;
    private int receiveBufferSize = 16384;
    private int sendBufferSize = 16384;
    private SocketChannel channel;
    private volatile boolean dumping = false;
    private long connectionId = -1L;
    private AtomicBoolean connected = new AtomicBoolean(false);

    public MysqlConnector() {
    }

    public MysqlConnector(InetSocketAddress address, String username, String password) {
        this.address = address;
        this.username = username;
        this.password = password;
    }

    public MysqlConnector(InetSocketAddress address, String username, String password, byte charsetNumber, String defaultSchema) {
        this(address, username, password);
        this.charsetNumber = charsetNumber;
        this.defaultSchema = defaultSchema;
    }

    public void connect() throws IOException {
        if (this.connected.compareAndSet(false, true)) {
            try {
                this.channel = SocketChannel.open();
                this.configChannel(this.channel);
                logger.info("connect MysqlConnection to {}...", (Object)this.address);
                this.channel.connect(this.address);
                this.negotiate(this.channel);
            }
            catch (Exception e) {
                this.disconnect();
                throw new IOException("connect " + this.address + " failure:" + ExceptionUtils.getStackTrace((Throwable)e));
            }
        } else {
            logger.error("the channel can't be connected twice.");
        }
    }

    public void reconnect() throws IOException {
        this.disconnect();
        this.connect();
    }

    public void disconnect() throws IOException {
        if (this.connected.compareAndSet(true, false)) {
            try {
                if (this.channel != null) {
                    this.channel.close();
                }
                logger.info("disConnect MysqlConnection to {}...", (Object)this.address);
            }
            catch (Exception e) {
                throw new IOException("disconnect " + this.address + " failure:" + ExceptionUtils.getStackTrace((Throwable)e));
            }
            if (this.dumping && this.connectionId >= 0L) {
                MysqlConnector connector = null;
                try {
                    connector = this.fork();
                    connector.connect();
                    MysqlUpdateExecutor executor = new MysqlUpdateExecutor(connector);
                    executor.update("KILL CONNECTION " + this.connectionId);
                }
                catch (Exception e) {
                    throw new IOException("KILL DUMP " + this.connectionId + " failure:" + ExceptionUtils.getStackTrace((Throwable)e));
                }
                finally {
                    if (connector != null) {
                        connector.disconnect();
                    }
                }
                this.dumping = false;
            }
        } else {
            logger.info("the channel {} is not connected", (Object)this.address);
        }
    }

    public boolean isConnected() {
        return this.channel != null && this.channel.isConnected();
    }

    public MysqlConnector fork() {
        MysqlConnector connector = new MysqlConnector();
        connector.setCharsetNumber(this.getCharsetNumber());
        connector.setDefaultSchema(this.getDefaultSchema());
        connector.setAddress(this.getAddress());
        connector.setPassword(this.password);
        connector.setUsername(this.getUsername());
        connector.setReceiveBufferSize(this.getReceiveBufferSize());
        connector.setSendBufferSize(this.getSendBufferSize());
        connector.setSoTimeout(this.getSoTimeout());
        return connector;
    }

    public void quit() throws IOException {
        QuitCommandPacket quit = new QuitCommandPacket();
        byte[] cmdBody = quit.toBytes();
        HeaderPacket quitHeader = new HeaderPacket();
        quitHeader.setPacketBodyLength(cmdBody.length);
        quitHeader.setPacketSequenceNumber((byte)0);
        PacketManager.write(this.channel, new ByteBuffer[]{ByteBuffer.wrap(quitHeader.toBytes()), ByteBuffer.wrap(cmdBody)});
    }

    private void configChannel(SocketChannel channel) throws IOException {
        channel.socket().setKeepAlive(true);
        channel.socket().setReuseAddress(true);
        channel.socket().setSoTimeout(this.soTimeout);
        channel.socket().setTcpNoDelay(true);
        channel.socket().setReceiveBufferSize(this.receiveBufferSize);
        channel.socket().setSendBufferSize(this.sendBufferSize);
    }

    private void negotiate(SocketChannel channel) throws IOException {
        HeaderPacket header = PacketManager.readHeader(channel, 4);
        byte[] body = PacketManager.readBytes(channel, header.getPacketBodyLength());
        if (body[0] < 0) {
            if (body[0] == -1) {
                ErrorPacket error = new ErrorPacket();
                error.fromBytes(body);
                throw new IOException("handshake exception:\n" + error.toString());
            }
            if (body[0] == -2) {
                throw new IOException("Unexpected EOF packet at handshake phase.");
            }
            throw new IOException("unpexpected packet with field_count=" + body[0]);
        }
        HandshakeInitializationPacket handshakePacket = new HandshakeInitializationPacket();
        handshakePacket.fromBytes(body);
        this.connectionId = handshakePacket.threadId;
        logger.info("handshake initialization packet received, prepare the client authentication packet to send");
        ClientAuthenticationPacket clientAuth = new ClientAuthenticationPacket();
        clientAuth.setCharsetNumber(this.charsetNumber);
        clientAuth.setUsername(this.username);
        clientAuth.setPassword(this.password);
        clientAuth.setServerCapabilities(handshakePacket.serverCapabilities);
        clientAuth.setDatabaseName(this.defaultSchema);
        clientAuth.setScrumbleBuff(this.joinAndCreateScrumbleBuff(handshakePacket));
        byte[] clientAuthPkgBody = clientAuth.toBytes();
        HeaderPacket h = new HeaderPacket();
        h.setPacketBodyLength(clientAuthPkgBody.length);
        h.setPacketSequenceNumber((byte)(header.getPacketSequenceNumber() + 1));
        PacketManager.write(channel, new ByteBuffer[]{ByteBuffer.wrap(h.toBytes()), ByteBuffer.wrap(clientAuthPkgBody)});
        logger.info("client authentication packet is sent out.");
        header = null;
        header = PacketManager.readHeader(channel, 4);
        body = null;
        body = PacketManager.readBytes(channel, header.getPacketBodyLength());
        assert (body != null);
        if (body[0] < 0) {
            if (body[0] == -1) {
                ErrorPacket err = new ErrorPacket();
                err.fromBytes(body);
                throw new IOException("Error When doing Client Authentication:" + err.toString());
            }
            if (body[0] == -2) {
                this.auth323(channel, header.getPacketSequenceNumber(), handshakePacket.seed);
            } else {
                throw new IOException("unpexpected packet with field_count=" + body[0]);
            }
        }
    }

    private void auth323(SocketChannel channel, byte packetSequenceNumber, byte[] seed) throws IOException {
        Reply323Packet r323 = new Reply323Packet();
        if (this.password != null && this.password.length() > 0) {
            r323.seed = MySQLPasswordEncrypter.scramble323(this.password, new String(seed)).getBytes();
        }
        byte[] b323Body = r323.toBytes();
        HeaderPacket h323 = new HeaderPacket();
        h323.setPacketBodyLength(b323Body.length);
        h323.setPacketSequenceNumber((byte)(packetSequenceNumber + 1));
        PacketManager.write(channel, new ByteBuffer[]{ByteBuffer.wrap(h323.toBytes()), ByteBuffer.wrap(b323Body)});
        logger.info("client 323 authentication packet is sent out.");
        HeaderPacket header = PacketManager.readHeader(channel, 4);
        byte[] body = PacketManager.readBytes(channel, header.getPacketBodyLength());
        assert (body != null);
        switch (body[0]) {
            case 0: {
                break;
            }
            case -1: {
                ErrorPacket err = new ErrorPacket();
                err.fromBytes(body);
                throw new IOException("Error When doing Client Authentication:" + err.toString());
            }
            default: {
                throw new IOException("unpexpected packet with field_count=" + body[0]);
            }
        }
    }

    private byte[] joinAndCreateScrumbleBuff(HandshakeInitializationPacket handshakePacket) throws IOException {
        byte[] dest = new byte[handshakePacket.seed.length + handshakePacket.restOfScrambleBuff.length];
        System.arraycopy(handshakePacket.seed, 0, dest, 0, handshakePacket.seed.length);
        System.arraycopy(handshakePacket.restOfScrambleBuff, 0, dest, handshakePacket.seed.length, handshakePacket.restOfScrambleBuff.length);
        return dest;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetSocketAddress address) {
        this.address = address;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public byte getCharsetNumber() {
        return this.charsetNumber;
    }

    public void setCharsetNumber(byte charsetNumber) {
        this.charsetNumber = charsetNumber;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public void setChannel(SocketChannel channel) {
        this.channel = channel;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public long getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(long connectionId) {
        this.connectionId = connectionId;
    }

    public boolean isDumping() {
        return this.dumping;
    }

    public void setDumping(boolean dumping) {
        this.dumping = dumping;
    }
}

