/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.driver.mysql;

import com.alibaba.otter.canal.parse.driver.mysql.MysqlConnector;
import com.alibaba.otter.canal.parse.driver.mysql.packets.HeaderPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.client.QueryCommandPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.ErrorPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.FieldPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.ResultSetHeaderPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.ResultSetPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.RowDataPacket;
import com.alibaba.otter.canal.parse.driver.mysql.utils.PacketManager;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;

public class MysqlQueryExecutor {
    private SocketChannel channel;

    public MysqlQueryExecutor(MysqlConnector connector) {
        if (!connector.isConnected()) {
            throw new RuntimeException("should execute connector.connect() first");
        }
        this.channel = connector.getChannel();
    }

    public MysqlQueryExecutor(SocketChannel ch) {
        this.channel = ch;
    }

    public ResultSetPacket query(String queryString) throws IOException {
        QueryCommandPacket cmd = new QueryCommandPacket();
        cmd.setQueryString(queryString);
        byte[] bodyBytes = cmd.toBytes();
        PacketManager.write(this.channel, bodyBytes);
        byte[] body = this.readNextPacket();
        if (body[0] < 0) {
            ErrorPacket packet = new ErrorPacket();
            packet.fromBytes(body);
            throw new IOException(packet + "\n with command: " + queryString);
        }
        ResultSetHeaderPacket rsHeader = new ResultSetHeaderPacket();
        rsHeader.fromBytes(body);
        ArrayList<FieldPacket> fields = new ArrayList<FieldPacket>();
        int i = 0;
        while ((long)i < rsHeader.getColumnCount()) {
            FieldPacket fp = new FieldPacket();
            fp.fromBytes(this.readNextPacket());
            fields.add(fp);
            ++i;
        }
        this.readEofPacket();
        ArrayList<RowDataPacket> rowData = new ArrayList<RowDataPacket>();
        while ((body = this.readNextPacket())[0] != -2) {
            RowDataPacket rowDataPacket = new RowDataPacket();
            rowDataPacket.fromBytes(body);
            rowData.add(rowDataPacket);
        }
        ResultSetPacket resultSet = new ResultSetPacket();
        resultSet.getFieldDescriptors().addAll(fields);
        for (RowDataPacket r : rowData) {
            resultSet.getFieldValues().addAll(r.getColumns());
        }
        resultSet.setSourceAddress(this.channel.socket().getRemoteSocketAddress());
        return resultSet;
    }

    private void readEofPacket() throws IOException {
        byte[] eofBody = this.readNextPacket();
        if (eofBody[0] != -2) {
            throw new IOException("EOF Packet is expected, but packet with field_count=" + eofBody[0] + " is found.");
        }
    }

    protected byte[] readNextPacket() throws IOException {
        HeaderPacket h = PacketManager.readHeader(this.channel, 4);
        return PacketManager.readBytes(this.channel, h.getPacketBodyLength());
    }
}

