/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.driver.mysql.utils;

import com.alibaba.otter.canal.parse.driver.mysql.packets.HeaderPacket;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public abstract class PacketManager {
    public static HeaderPacket readHeader(SocketChannel ch, int len) throws IOException {
        HeaderPacket header = new HeaderPacket();
        header.fromBytes(PacketManager.readBytesAsBuffer(ch, len).array());
        return header;
    }

    public static ByteBuffer readBytesAsBuffer(SocketChannel ch, int len) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(len);
        while (buffer.hasRemaining()) {
            int readNum = ch.read(buffer);
            if (readNum != -1) continue;
            throw new IOException("Unexpected End Stream");
        }
        return buffer;
    }

    public static byte[] readBytes(SocketChannel ch, int len) throws IOException {
        return PacketManager.readBytesAsBuffer(ch, len).array();
    }

    public static void write(SocketChannel ch, ByteBuffer[] srcs) throws IOException {
        long total = 0L;
        for (ByteBuffer buffer : srcs) {
            total += (long)buffer.remaining();
        }
        ch.write(srcs);
    }

    public static void write(SocketChannel ch, byte[] body) throws IOException {
        PacketManager.write(ch, body, (byte)0);
    }

    public static void write(SocketChannel ch, byte[] body, byte packetSeqNumber) throws IOException {
        HeaderPacket header = new HeaderPacket();
        header.setPacketBodyLength(body.length);
        header.setPacketSequenceNumber(packetSeqNumber);
        PacketManager.write(ch, new ByteBuffer[]{ByteBuffer.wrap(header.toBytes()), ByteBuffer.wrap(body)});
    }
}

