/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.common;

import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class SofaBootRpcSpringUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SofaBootRpcSpringUtil.class);

    public static Object getSpringBean(String beanRef, String beanClass, ApplicationContext applicationContext, ClassLoader appClassLoader, String appName) {
        Object callbackHandler = null;
        if (StringUtils.hasText((String)beanRef)) {
            if (applicationContext == null) {
                LOGGER.errorWithApp(appName, "04006", new Object[]{beanRef});
            } else {
                callbackHandler = applicationContext.getBean(beanRef);
            }
        } else if (StringUtils.hasText((String)beanClass)) {
            callbackHandler = SofaBootRpcSpringUtil.newInstance(beanClass, appClassLoader, appName);
        }
        return callbackHandler;
    }

    public static Object getSpringBean(String beanRef, ApplicationContext applicationContext, ClassLoader appClassLoader, String appName) {
        Object object = null;
        if (StringUtils.hasText((String)beanRef)) {
            if (applicationContext == null) {
                LOGGER.errorWithApp(appName, "04006", new Object[]{beanRef});
            } else {
                object = applicationContext.getBean(beanRef);
            }
        }
        return object;
    }

    public static Object newInstance(String clazz, ClassLoader loader, String appName) {
        if (!StringUtils.hasText((String)clazz)) {
            return null;
        }
        try {
            return Class.forName(clazz, true, loader).newInstance();
        }
        catch (Exception e) {
            LOGGER.errorWithApp(appName, "02107", new Object[]{clazz, e});
            throw new RuntimeException(LogCodes.getLog((String)"02107", (Object[])new Object[]{clazz}), e);
        }
    }
}

