/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.config;

import com.alipay.sofa.rpc.boot.common.SofaBootRpcParserUtil;
import com.alipay.sofa.rpc.boot.config.SofaBootRpcConfig;
import com.alipay.sofa.rpc.client.aft.FaultToleranceConfig;
import com.alipay.sofa.rpc.client.aft.FaultToleranceConfigManager;

public class FaultToleranceConfigurator {
    public void startFaultTolerance() {
        String appName = SofaBootRpcConfig.getPropertyAllCircumstances("spring.application.name");
        String regulationEffectiveStr = SofaBootRpcConfig.getPropertyAllCircumstances("rpc.aft.regulation.effective");
        String degradeEffectiveStr = SofaBootRpcConfig.getPropertyAllCircumstances("rpc.aft.degrade.effective");
        String timeWindowStr = SofaBootRpcConfig.getPropertyAllCircumstances("rpc.aft.time.window");
        String leastWindowCountStr = SofaBootRpcConfig.getPropertyAllCircumstances("rpc.aft.least.window.count");
        String leastWindowExceptionRateMultipleStr = SofaBootRpcConfig.getPropertyAllCircumstances("rpc.aft.least.window.exception.rate.multiple");
        String weightDegradeRateStr = SofaBootRpcConfig.getPropertyAllCircumstances("rpc.aft.weight.degrade.rate");
        String weightRecoverRateStr = SofaBootRpcConfig.getPropertyAllCircumstances("rpc.aft.weight.recover.rate");
        String degradeLeastWeightStr = SofaBootRpcConfig.getPropertyAllCircumstances("rpc.aft.degrade.least.weight");
        String degradeMaxIpCountStr = SofaBootRpcConfig.getPropertyAllCircumstances("rpc.aft.degrade.max.ip.count");
        Boolean regulationEffective = SofaBootRpcParserUtil.parseBoolean(regulationEffectiveStr);
        Boolean degradeEffective = SofaBootRpcParserUtil.parseBoolean(degradeEffectiveStr);
        Long timeWindow = SofaBootRpcParserUtil.parseLong(timeWindowStr);
        Long leastWindowCount = SofaBootRpcParserUtil.parseLong(leastWindowCountStr);
        Double leastWindowExceptionRateMultiple = SofaBootRpcParserUtil.parseDouble(leastWindowExceptionRateMultipleStr);
        Double weightDegradeRate = SofaBootRpcParserUtil.parseDouble(weightDegradeRateStr);
        Double weightRecoverRate = SofaBootRpcParserUtil.parseDouble(weightRecoverRateStr);
        Integer degradeLeastWeight = SofaBootRpcParserUtil.parseInteger(degradeLeastWeightStr);
        Integer degradeMaxIpCount = SofaBootRpcParserUtil.parseInteger(degradeMaxIpCountStr);
        FaultToleranceConfig faultToleranceConfig = new FaultToleranceConfig();
        if (regulationEffective != null) {
            faultToleranceConfig.setRegulationEffective(regulationEffective.booleanValue());
        }
        if (degradeEffective != null) {
            faultToleranceConfig.setDegradeEffective(degradeEffective.booleanValue());
        }
        if (timeWindow != null) {
            faultToleranceConfig.setTimeWindow(timeWindow.longValue());
        }
        if (leastWindowCount != null) {
            faultToleranceConfig.setLeastWindowCount(leastWindowCount.longValue());
        }
        if (leastWindowExceptionRateMultiple != null) {
            faultToleranceConfig.setLeastWindowExceptionRateMultiple(leastWindowExceptionRateMultiple.doubleValue());
        }
        if (weightDegradeRate != null) {
            faultToleranceConfig.setWeightDegradeRate(weightDegradeRate.doubleValue());
        }
        if (weightRecoverRate != null) {
            faultToleranceConfig.setWeightRecoverRate(weightRecoverRate.doubleValue());
        }
        if (degradeLeastWeight != null) {
            faultToleranceConfig.setDegradeLeastWeight(degradeLeastWeight.intValue());
        }
        if (degradeMaxIpCount != null) {
            faultToleranceConfig.setDegradeMaxIpCount(degradeMaxIpCount.intValue());
        }
        FaultToleranceConfigManager.putAppConfig((String)appName, (FaultToleranceConfig)faultToleranceConfig);
    }
}

