/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.runtime.adapter;

import com.alipay.sofa.rpc.boot.container.ConsumerConfigContainer;
import com.alipay.sofa.rpc.boot.container.ProviderConfigContainer;
import com.alipay.sofa.rpc.boot.container.RegistryConfigContainer;
import com.alipay.sofa.rpc.boot.runtime.adapter.helper.ConsumerConfigHelper;
import com.alipay.sofa.rpc.boot.runtime.adapter.helper.ProviderConfigHelper;
import com.alipay.sofa.rpc.boot.runtime.binding.RpcBinding;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.registry.Registry;
import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.spi.binding.Binding;
import com.alipay.sofa.runtime.spi.binding.BindingAdapter;
import com.alipay.sofa.runtime.spi.binding.Contract;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import java.util.List;

public abstract class RpcBindingAdapter
implements BindingAdapter<RpcBinding> {
    public void preOutBinding(Object contract, RpcBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
        String uniqueName = ProviderConfigContainer.createUniqueName((Contract)contract, binding);
        ProviderConfig providerConfig = ProviderConfigHelper.getProviderConfig((Contract)contract, binding, target);
        try {
            ProviderConfigContainer.addProviderConfig(uniqueName, providerConfig);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(LogCodes.getLog((String)"02104"), (Throwable)e);
        }
    }

    public Object outBinding(Object contract, RpcBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
        String uniqueName = ProviderConfigContainer.createUniqueName((Contract)contract, binding);
        ProviderConfig providerConfig = ProviderConfigContainer.getProviderConfig(uniqueName);
        if (providerConfig == null) {
            throw new ServiceRuntimeException(LogCodes.getLog((String)"00304", (Object[])new Object[]{uniqueName}));
        }
        try {
            providerConfig.export();
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(LogCodes.getLog((String)"02104"), (Throwable)e);
        }
        if (ProviderConfigContainer.isAllowPublish()) {
            Registry registry = RegistryConfigContainer.getRegistry();
            providerConfig.setRegister(true);
            registry.register(providerConfig);
        }
        return Boolean.TRUE;
    }

    public void preUnoutBinding(Object contract, RpcBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
        ProviderConfig providerConfig = ProviderConfigHelper.getProviderConfig((Contract)contract, binding, target);
        try {
            providerConfig.unExport();
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(LogCodes.getLog((String)"02105"), (Throwable)e);
        }
    }

    public void postUnoutBinding(Object contract, RpcBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
        ProviderConfig metadata = ProviderConfigHelper.getProviderConfig((Contract)contract, binding, target);
        try {
            String key = ProviderConfigContainer.createUniqueName((Contract)contract, binding);
            List servers = ProviderConfigContainer.getProviderConfig(key).getServer();
            for (ServerConfig server : servers) {
                server.getServer().unRegisterProcessor(metadata, false);
            }
            ProviderConfigContainer.removeProviderConfig(key);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(LogCodes.getLog((String)"02106"), (Throwable)e);
        }
    }

    public Object inBinding(Object contract, RpcBinding binding, SofaRuntimeContext sofaRuntimeContext) {
        ConsumerConfig consumerConfig = ConsumerConfigHelper.getConsumerConfig((Contract)contract, binding);
        ConsumerConfigContainer.addConsumerConfig((Binding)binding, consumerConfig);
        try {
            Object result = consumerConfig.refer();
            binding.setConsumerConfig(consumerConfig);
            return result;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(LogCodes.getLog((String)"02103"), (Throwable)e);
        }
    }

    public void unInBinding(Object contract, RpcBinding binding, SofaRuntimeContext sofaRuntimeContext) {
        try {
            ConsumerConfigContainer.removeAndUnReferConsumerConfig((Binding)binding);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(LogCodes.getLog((String)"02424"), (Throwable)e);
        }
    }

    public Class<RpcBinding> getBindingClass() {
        return RpcBinding.class;
    }
}

