/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.runtime.adapter.helper;

import com.alipay.sofa.rpc.boot.common.SofaBootRpcRuntimeException;
import com.alipay.sofa.rpc.boot.config.SofaBootRpcConfig;
import com.alipay.sofa.rpc.boot.container.RegistryConfigContainer;
import com.alipay.sofa.rpc.boot.runtime.binding.RpcBinding;
import com.alipay.sofa.rpc.boot.runtime.binding.RpcBindingMethodInfo;
import com.alipay.sofa.rpc.boot.runtime.param.RpcBindingParam;
import com.alipay.sofa.rpc.config.ApplicationConfig;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.MethodConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.core.invoke.SofaResponseCallback;
import com.alipay.sofa.rpc.filter.Filter;
import com.alipay.sofa.runtime.spi.binding.Contract;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ConsumerConfigHelper {
    public static ConsumerConfig getConsumerConfig(Contract contract, RpcBinding binding) {
        RpcBindingParam param = binding.getRpcBindingParam();
        String appName = SofaBootRpcConfig.getProperty("spring.application.name");
        String id = binding.getBeanId();
        String interfaceId = contract.getInterfaceType().getName();
        String uniqueId = contract.getUniqueId();
        Integer timeout = param.getTimeout();
        Integer retries = param.getRetries();
        String type = param.getType();
        Integer addressWaitTime = param.getAddressWaitTime();
        Object callbackHandler = param.getCallbackHandler();
        String genericInterface = param.getGenericInterface();
        List<Filter> filters = param.getFilters();
        List<MethodConfig> methodConfigs = ConsumerConfigHelper.convertToMethodConfig(param.getMethodInfos());
        String targetUrl = param.getTargetUrl();
        RegistryConfig registryConfig = RegistryConfigContainer.getRegistryConfig();
        ConsumerConfig consumerConfig = new ConsumerConfig();
        if (StringUtils.hasText((String)appName)) {
            consumerConfig.setApplication(new ApplicationConfig().setAppName(appName));
        }
        if (StringUtils.hasText((String)id)) {
            consumerConfig.setId(id);
        }
        if (StringUtils.hasText((String)genericInterface)) {
            consumerConfig.setGeneric(true);
            consumerConfig.setInterfaceId(genericInterface);
        } else if (StringUtils.hasText((String)interfaceId)) {
            consumerConfig.setInterfaceId(interfaceId);
        }
        if (StringUtils.hasText((String)uniqueId)) {
            consumerConfig.setUniqueId(uniqueId);
        }
        if (timeout != null) {
            consumerConfig.setTimeout(timeout.intValue());
        }
        if (retries != null) {
            consumerConfig.setRetries(retries.intValue());
        }
        if (StringUtils.hasText((String)type)) {
            consumerConfig.setInvokeType(type);
        }
        if (addressWaitTime != null) {
            consumerConfig.setAddressWait(addressWaitTime.intValue());
        }
        if (callbackHandler != null) {
            if (callbackHandler instanceof SofaResponseCallback) {
                consumerConfig.setOnReturn((SofaResponseCallback)callbackHandler);
            } else {
                throw new SofaBootRpcRuntimeException("callback handler must implement SofaResponseCallback [" + callbackHandler + "]");
            }
        }
        if (!CollectionUtils.isEmpty(filters)) {
            consumerConfig.setFilterRef(filters);
        }
        if (!CollectionUtils.isEmpty(methodConfigs)) {
            consumerConfig.setMethods(methodConfigs);
        }
        if (StringUtils.hasText((String)targetUrl)) {
            consumerConfig.setDirectUrl(targetUrl);
            consumerConfig.setSubscribe(false);
            consumerConfig.setRegister(false);
        }
        consumerConfig.setRegistry(registryConfig);
        String protocol = binding.getBindingType().getType();
        consumerConfig.setBootstrap(protocol);
        if (protocol.equals("dubbo")) {
            consumerConfig.setInJVM(false);
        }
        return consumerConfig.setProtocol(protocol);
    }

    private static List<MethodConfig> convertToMethodConfig(List<RpcBindingMethodInfo> methodInfos) {
        ArrayList<MethodConfig> methodConfigs = new ArrayList<MethodConfig>();
        if (!CollectionUtils.isEmpty(methodInfos)) {
            for (RpcBindingMethodInfo info : methodInfos) {
                String name = info.getName();
                Integer timeout = info.getTimeout();
                Integer retries = info.getRetries();
                String type = info.getType();
                Object callbackHandler = info.getCallbackHandler();
                MethodConfig methodConfig = new MethodConfig();
                methodConfig.setName(name);
                if (timeout != null) {
                    methodConfig.setTimeout(timeout);
                }
                if (retries != null) {
                    methodConfig.setRetries(retries);
                }
                if (StringUtils.hasText((String)type)) {
                    methodConfig.setInvokeType(type);
                }
                if (callbackHandler != null) {
                    if (callbackHandler instanceof SofaResponseCallback) {
                        methodConfig.setOnReturn((SofaResponseCallback)callbackHandler);
                    } else {
                        throw new SofaBootRpcRuntimeException("callback handler must implement SofaResponseCallback [" + callbackHandler + "]");
                    }
                }
                methodConfigs.add(methodConfig);
            }
        }
        return methodConfigs;
    }
}

