/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot;

import com.alipay.sofa.infra.log.space.SofaBootLogSpaceIsolationInit;
import com.alipay.sofa.rpc.boot.common.SofaBootRpcRuntimeException;
import com.alipay.sofa.rpc.boot.config.SofaBootRpcConfig;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class SofaBootRpcInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    public void initialize(ConfigurableApplicationContext applicationContext) {
        if (SofaBootRpcConfig.getEnvironment() == null) {
            SofaBootRpcConfig.setEnvironment((Environment)applicationContext.getEnvironment());
        }
        this.checkAppName();
        this.initLog((Environment)applicationContext.getEnvironment());
    }

    private void checkAppName() {
        String appName = SofaBootRpcConfig.getPropertyAllCircumstances("spring.application.name");
        if (!StringUtils.hasText((String)appName)) {
            throw new SofaBootRpcRuntimeException("Please add 'spring.application.name' in application.properties");
        }
    }

    private void initLog(Environment environment) {
        String logLevelKey = "logging.level.com.alipay.sofa.rpc.boot";
        SofaBootLogSpaceIsolationInit.initSofaBootLogger((Environment)environment, (String)logLevelKey);
    }
}

