/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.config;

import com.alipay.sofa.rpc.boot.config.SofaBootRpcConfig;
import com.alipay.sofa.rpc.boot.config.SofaBootRpcConfigConstants;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

public class ZookeeperConfigurator {
    private static final String FILE = "file";
    private static String address;
    private static final Map<String, String> PARAM_MAP;
    private static boolean alreadyParse;

    public static String getParamValue(String key) {
        if (StringUtils.hasText((String)key)) {
            return PARAM_MAP.get(key);
        }
        return null;
    }

    public static String getFile() {
        String file = PARAM_MAP.get(FILE);
        if (!StringUtils.hasText((String)file)) {
            file = SofaBootRpcConfigConstants.REGISTRY_FILE_PATH_DEFAULT;
        }
        return file;
    }

    public static void parseConfig(String config) {
        if (StringUtils.hasText((String)config) && config.startsWith("zookeeper")) {
            String value = config.substring(12);
            if (!value.contains("?")) {
                address = value;
            } else {
                int index = value.lastIndexOf(63);
                address = value.substring(0, index);
                String paramString = value.substring(index + 1);
                ZookeeperConfigurator.parseParam(paramString);
            }
        }
    }

    public static void parseConfig() {
        if (!alreadyParse) {
            String config = SofaBootRpcConfig.getPropertyAllCircumstances("com.alipay.sofa.rpc.registry.address");
            ZookeeperConfigurator.parseConfig(config);
            alreadyParse = true;
        }
    }

    private static void parseParam(String paramString) {
        if (paramString.contains("&")) {
            String[] paramSplit;
            for (String param : paramSplit = paramString.split("&")) {
                ZookeeperConfigurator.parseKeyValue(param);
            }
        } else {
            ZookeeperConfigurator.parseKeyValue(paramString);
        }
    }

    private static void parseKeyValue(String kv) {
        String[] kvSplit = kv.split("=");
        String key = kvSplit[0];
        String value = kvSplit[1];
        PARAM_MAP.put(key, value);
    }

    public static String getAddress() {
        return address;
    }

    public static void setAddress(String address) {
        ZookeeperConfigurator.address = address;
    }

    static {
        PARAM_MAP = new HashMap<String, String>();
        alreadyParse = false;
    }
}

