/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.container;

import com.alipay.sofa.rpc.boot.log.SofaBootRpcLoggerFactory;
import com.alipay.sofa.rpc.boot.runtime.binding.RpcBinding;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.registry.Registry;
import com.alipay.sofa.runtime.spi.binding.Contract;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.springframework.util.StringUtils;

public class ProviderConfigContainer {
    private static final Logger LOGGER = SofaBootRpcLoggerFactory.getLogger(ProviderConfigContainer.class);
    private static boolean allowPublish = false;
    private static final ConcurrentMap<String, ProviderConfig> RPC_SERVICE_CONTAINER = new ConcurrentHashMap<String, ProviderConfig>(256);

    public static void addProviderConfig(String key, ProviderConfig providerConfig) {
        if (providerConfig != null) {
            if (RPC_SERVICE_CONTAINER.containsKey(key)) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("The same services and protocols already exist.key[" + key + "];protocol[" + providerConfig.getServer().get(0) + "]");
                }
            } else {
                RPC_SERVICE_CONTAINER.put(key, providerConfig);
            }
        }
    }

    public static ProviderConfig getProviderConfig(String key) {
        return (ProviderConfig)RPC_SERVICE_CONTAINER.get(key);
    }

    public static void removeProviderConfig(String key) {
        RPC_SERVICE_CONTAINER.remove(key);
    }

    public static Collection<ProviderConfig> getAllProviderConfig() {
        return RPC_SERVICE_CONTAINER.values();
    }

    public static void publishAllProviderConfig(Registry registry) {
        for (ProviderConfig providerConfig : ProviderConfigContainer.getAllProviderConfig()) {
            ServerConfig serverConfig = (ServerConfig)providerConfig.getServer().get(0);
            if (serverConfig.getProtocol().equalsIgnoreCase("dubbo")) continue;
            providerConfig.setRegister(true);
            registry.register(providerConfig);
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("service published.  interfaceId[" + providerConfig.getInterfaceId() + "]; protocol[" + serverConfig.getProtocol() + "]");
        }
    }

    public static void exportAllDubboProvideConfig() {
        for (ProviderConfig providerConfig : ProviderConfigContainer.getAllProviderConfig()) {
            ServerConfig serverConfig = (ServerConfig)providerConfig.getServer().get(0);
            if (!serverConfig.getProtocol().equalsIgnoreCase("dubbo")) continue;
            providerConfig.setRegister(true);
            providerConfig.export();
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("service published.  interfaceId[" + providerConfig.getInterfaceId() + "]; protocol[" + serverConfig.getProtocol() + "]");
        }
    }

    public static void unExportAllProviderConfig() {
        for (ProviderConfig providerConfig : ProviderConfigContainer.getAllProviderConfig()) {
            providerConfig.unExport();
        }
    }

    public static boolean isAllowPublish() {
        return allowPublish;
    }

    public static void setAllowPublish(boolean allowPublish) {
        ProviderConfigContainer.allowPublish = allowPublish;
    }

    public static String createUniqueName(Contract contract, RpcBinding binding) {
        String uniqueId = "";
        String version = ":1.0";
        String protocol = "";
        if (StringUtils.hasText((String)contract.getUniqueId())) {
            uniqueId = ":" + contract.getUniqueId();
        }
        if (StringUtils.hasText((String)contract.getProperty("version"))) {
            version = ":" + contract.getProperty("version");
        }
        if (StringUtils.hasText((String)binding.getBindingType().getType())) {
            protocol = ":" + binding.getBindingType().getType();
        }
        return new StringBuffer(contract.getInterfaceType().getName()).append(version).append(uniqueId).append(protocol).toString();
    }
}

