/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.container;

import com.alipay.sofa.rpc.boot.common.SofaBootRpcRuntimeException;
import com.alipay.sofa.rpc.boot.config.LocalFileConfigurator;
import com.alipay.sofa.rpc.boot.config.SofaBootRpcConfig;
import com.alipay.sofa.rpc.boot.config.SofaBootRpcConfigConstants;
import com.alipay.sofa.rpc.boot.config.ZookeeperConfigurator;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.registry.Registry;
import com.alipay.sofa.rpc.registry.RegistryFactory;

public class RegistryConfigContainer {
    private static volatile RegistryConfig localRegistryConfig;
    private static volatile RegistryConfig zookeeperRegistryConfig;

    public static Registry getRegistry() {
        Registry registry = RegistryFactory.getRegistry((RegistryConfig)RegistryConfigContainer.getRegistryConfig());
        registry.init();
        registry.start();
        return registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RegistryConfig getRegistryConfig() throws SofaBootRpcRuntimeException {
        String registryConfig = SofaBootRpcConfig.getPropertyAllCircumstances("com.alipay.sofa.rpc.registry.address");
        if (StringUtils.isBlank((CharSequence)registryConfig) || registryConfig.startsWith("local")) {
            if (localRegistryConfig != null) return localRegistryConfig;
            Class<RegistryConfigContainer> clazz = RegistryConfigContainer.class;
            synchronized (RegistryConfigContainer.class) {
                if (localRegistryConfig != null) return localRegistryConfig;
                localRegistryConfig = RegistryConfigContainer.createLocalRegistryConfig();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return localRegistryConfig;
            }
        }
        if (!registryConfig.startsWith("zookeeper")) throw new SofaBootRpcRuntimeException("protocol[" + registryConfig + "] is not supported");
        if (zookeeperRegistryConfig != null) return zookeeperRegistryConfig;
        Class<RegistryConfigContainer> clazz = RegistryConfigContainer.class;
        synchronized (RegistryConfigContainer.class) {
            if (zookeeperRegistryConfig != null) return zookeeperRegistryConfig;
            zookeeperRegistryConfig = RegistryConfigContainer.createZookeeperRegistryConfig();
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return zookeeperRegistryConfig;
        }
    }

    static RegistryConfig createLocalRegistryConfig() {
        LocalFileConfigurator.parseConfig();
        String filePath = LocalFileConfigurator.getFile();
        if (StringUtils.isBlank((CharSequence)filePath)) {
            filePath = SofaBootRpcConfigConstants.REGISTRY_FILE_PATH_DEFAULT;
        }
        RegistryConfig registryConfig = new RegistryConfig().setFile(filePath).setProtocol("local");
        return registryConfig;
    }

    static RegistryConfig createZookeeperRegistryConfig() {
        ZookeeperConfigurator.parseConfig();
        String address = ZookeeperConfigurator.getAddress();
        String filePath = ZookeeperConfigurator.getFile();
        RegistryConfig registryConfig = new RegistryConfig().setAddress(address).setFile(filePath).setProtocol("zookeeper");
        return registryConfig;
    }

    public static void removeAllRegistryConfig() {
        localRegistryConfig = null;
        zookeeperRegistryConfig = null;
    }
}

