/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.container;

import com.alipay.sofa.rpc.boot.common.SofaBootRpcRuntimeException;
import com.alipay.sofa.rpc.filter.Filter;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class RpcFilterContainer {
    private static List<String> filterIds = new CopyOnWriteArrayList<String>();
    private static List<String> filterClasses = new CopyOnWriteArrayList<String>();
    private static boolean alreadyLoad = false;
    private static final Object LOAD_LOCK = new Object();
    private static List<Filter> filters = new CopyOnWriteArrayList<Filter>();

    public static void addFilterId(String filterId) {
        if (StringUtils.hasText((String)filterId)) {
            filterIds.add(filterId);
        }
    }

    public static void addFilterClass(String filterClass) {
        if (StringUtils.hasText((String)filterClass)) {
            filterClasses.add(filterClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Filter> getFilters(ApplicationContext applicationContext) {
        if (applicationContext != null) {
            if (!alreadyLoad) {
                Object object = LOAD_LOCK;
                synchronized (object) {
                    if (!alreadyLoad) {
                        RpcFilterContainer.loadFilters(applicationContext);
                        alreadyLoad = true;
                    }
                }
            }
            return filters;
        }
        throw new SofaBootRpcRuntimeException("The applicationContext should not be null");
    }

    public static void loadFilters(ApplicationContext applicationContext) {
        for (String filterId : filterIds) {
            filters.add((Filter)applicationContext.getBean(filterId, Filter.class));
        }
        for (String clazz : filterClasses) {
            Class<?> filterClass = null;
            try {
                filterClass = Class.forName(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new SofaBootRpcRuntimeException("Can not find filter class " + clazz + " ", e);
            }
            if (Filter.class.isAssignableFrom(filterClass)) {
                try {
                    filters.add((Filter)filterClass.newInstance());
                    continue;
                }
                catch (Exception e) {
                    throw new SofaBootRpcRuntimeException("Error happen when create instance of " + filterClass + " ", e);
                }
            }
            throw new SofaBootRpcRuntimeException("The class of " + clazz + " should be a subclass of Filter");
        }
    }
}

