/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.container;

import com.alipay.sofa.rpc.boot.common.RpcThreadPoolMonitor;
import com.alipay.sofa.rpc.boot.common.SofaBootRpcRuntimeException;
import com.alipay.sofa.rpc.boot.config.SofaBootRpcConfig;
import com.alipay.sofa.rpc.boot.config.SofaBootRpcConfigConstants;
import com.alipay.sofa.rpc.boot.log.SofaBootRpcLoggerFactory;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.server.Server;
import com.alipay.sofa.rpc.server.ServerFactory;
import com.alipay.sofa.rpc.server.bolt.BoltServer;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.springframework.util.StringUtils;

public class ServerConfigContainer {
    private static final Logger LOGGER = SofaBootRpcLoggerFactory.getLogger(ServerConfigContainer.class);
    private static volatile ServerConfig boltServerConfig;
    private static final Object BOLT_LOCK;
    private static volatile ServerConfig restServerConfig;
    private static final Object REST_LOCK;
    private static volatile ServerConfig dubboServerConfig;
    private static final Object DUBBO_LOCK;

    public static boolean isNeedStart() {
        return boltServerConfig != null || restServerConfig != null || dubboServerConfig != null;
    }

    public static void startServers() {
        if (boltServerConfig != null) {
            boltServerConfig.buildIfAbsent().start();
            BoltServer server = (BoltServer)boltServerConfig.getServer();
            ThreadPoolExecutor threadPoolExecutor = server.getBizThreadPool();
            if (threadPoolExecutor != null) {
                new RpcThreadPoolMonitor(threadPoolExecutor).start();
            } else if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("the business threadpool can not be get");
            }
        }
        if (restServerConfig != null) {
            restServerConfig.buildIfAbsent().start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerConfig getServerConfig(String protocol) {
        if (protocol.equalsIgnoreCase("bolt")) {
            if (boltServerConfig == null) {
                Object object = BOLT_LOCK;
                synchronized (object) {
                    if (boltServerConfig == null) {
                        boltServerConfig = ServerConfigContainer.createBoltServerConfig();
                    }
                }
            }
            return boltServerConfig;
        }
        if (protocol.equalsIgnoreCase("rest")) {
            if (restServerConfig == null) {
                Object object = REST_LOCK;
                synchronized (object) {
                    if (restServerConfig == null) {
                        restServerConfig = ServerConfigContainer.createRestServerConfig();
                    }
                }
            }
            return restServerConfig;
        }
        if (protocol.equalsIgnoreCase("dubbo")) {
            if (dubboServerConfig == null) {
                Object object = DUBBO_LOCK;
                synchronized (object) {
                    if (dubboServerConfig == null) {
                        dubboServerConfig = ServerConfigContainer.createDubboServerConfig();
                    }
                }
            }
            return dubboServerConfig;
        }
        throw new SofaBootRpcRuntimeException("protocol [" + protocol + "] is not supported");
    }

    public static Server getServer(String protocol) {
        return ServerFactory.getServer((ServerConfig)ServerConfigContainer.getServerConfig(protocol));
    }

    static ServerConfig createBoltServerConfig() {
        String portStr = SofaBootRpcConfig.getPropertyAllCircumstances("com.alipay.sofa.rpc.bolt.port");
        String ioThreadCountStr = SofaBootRpcConfig.getPropertyAllCircumstances("com.alipay.sofa.rpc.bolt.io.thread.count");
        String executorThreadCountStr = SofaBootRpcConfig.getPropertyAllCircumstances("com.alipay.sofa.rpc.bolt.executor.thread.count");
        String acceptsCountStr = SofaBootRpcConfig.getPropertyAllCircumstances("com.alipay.sofa.rpc.bolt.accepts.count");
        ServerConfig serverConfig = new ServerConfig();
        if (StringUtils.hasText((String)portStr)) {
            serverConfig.setPort(Integer.parseInt(portStr));
        }
        if (StringUtils.hasText((String)ioThreadCountStr)) {
            serverConfig.setIoThreads(Integer.parseInt(ioThreadCountStr));
        }
        if (StringUtils.hasText((String)executorThreadCountStr)) {
            serverConfig.setMaxThreads(Integer.parseInt(executorThreadCountStr));
        }
        if (StringUtils.hasText((String)acceptsCountStr)) {
            serverConfig.setAccepts(Integer.parseInt(acceptsCountStr));
        }
        serverConfig.setAutoStart(false);
        return serverConfig.setProtocol("bolt");
    }

    static ServerConfig createRestServerConfig() {
        String hostName = SofaBootRpcConfig.getPropertyAllCircumstances("com.alipay.sofa.rpc.rest.hostname");
        String portStr = SofaBootRpcConfig.getPropertyAllCircumstances("com.alipay.sofa.rpc.rest.port");
        String ioThreadCountStr = SofaBootRpcConfig.getPropertyAllCircumstances("com.alipay.sofa.rpc.rest.io.thread.count");
        String executorThreadCountStr = SofaBootRpcConfig.getPropertyAllCircumstances("com.alipay.sofa.rpc.rest.executor.thread.count");
        String maxRequestSizeStr = SofaBootRpcConfig.getPropertyAllCircumstances("com.alipay.sofa.rpc.rest.max.request.size");
        String telnetStr = SofaBootRpcConfig.getPropertyAllCircumstances("com.alipay.sofa.rpc.rest.telnet");
        String daemonStr = SofaBootRpcConfig.getPropertyAllCircumstances("com.alipay.sofa.rpc.rest.daemon");
        int port = 0;
        int ioThreadCount = 0;
        int executorThreadCount = 0;
        int maxRequestSize = 0;
        boolean telnet = false;
        boolean daemon = true;
        if (!StringUtils.hasText((String)hostName)) {
            hostName = null;
        }
        port = !StringUtils.hasText((String)portStr) ? 8341 : Integer.parseInt(portStr);
        ioThreadCount = !StringUtils.hasText((String)ioThreadCountStr) ? SofaBootRpcConfigConstants.REST_IO_THREAD_COUNT_DEFAULT : Integer.parseInt(ioThreadCountStr);
        executorThreadCount = !StringUtils.hasText((String)executorThreadCountStr) ? 200 : Integer.parseInt(executorThreadCountStr);
        maxRequestSize = !StringUtils.hasText((String)maxRequestSizeStr) ? 0xA00000 : Integer.parseInt(maxRequestSizeStr);
        telnet = !StringUtils.hasText((String)telnetStr) ? true : Boolean.parseBoolean(telnetStr);
        daemon = !StringUtils.hasText((String)daemonStr) ? true : Boolean.parseBoolean(daemonStr);
        ServerConfig serverConfig = new ServerConfig().setBoundHost(hostName).setPort(port).setIoThreads(ioThreadCount).setMaxThreads(executorThreadCount).setPayload(maxRequestSize).setTelnet(telnet).setDaemon(daemon);
        serverConfig.setAutoStart(false);
        return serverConfig.setProtocol("rest");
    }

    static ServerConfig createDubboServerConfig() {
        String portStr = SofaBootRpcConfig.getPropertyAllCircumstances("com.alipay.sofa.rpc.dubbo.port");
        String ioThreadCountStr = SofaBootRpcConfig.getPropertyAllCircumstances("com.alipay.sofa.rpc.dubbo.io.thread.count");
        String executorThreadCountStr = SofaBootRpcConfig.getPropertyAllCircumstances("com.alipay.sofa.rpc.dubbo.executor.thread.count");
        String acceptsCountStr = SofaBootRpcConfig.getPropertyAllCircumstances("com.alipay.sofa.rpc.dubbo.accepts.count");
        ServerConfig serverConfig = new ServerConfig();
        if (StringUtils.hasText((String)portStr)) {
            serverConfig.setPort(Integer.parseInt(portStr));
        } else {
            serverConfig.setPort(20880);
        }
        if (StringUtils.hasText((String)ioThreadCountStr)) {
            serverConfig.setIoThreads(Integer.parseInt(ioThreadCountStr));
        }
        if (StringUtils.hasText((String)executorThreadCountStr)) {
            serverConfig.setMaxThreads(Integer.parseInt(executorThreadCountStr));
        }
        if (StringUtils.hasText((String)acceptsCountStr)) {
            serverConfig.setAccepts(Integer.parseInt(acceptsCountStr));
        }
        serverConfig.setAutoStart(false);
        return serverConfig.setProtocol("dubbo");
    }

    public static void closeAllServer() {
        if (boltServerConfig != null) {
            boltServerConfig.destroy();
            boltServerConfig = null;
        }
        if (restServerConfig != null) {
            restServerConfig.destroy();
            restServerConfig = null;
        }
        if (dubboServerConfig != null) {
            dubboServerConfig.destroy();
            dubboServerConfig = null;
        }
    }

    static {
        BOLT_LOCK = new Object();
        REST_LOCK = new Object();
        DUBBO_LOCK = new Object();
    }
}

