/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.runtime.parser;

import com.alipay.sofa.infra.config.spring.namespace.spi.SofaBootTagNameSupport;
import com.alipay.sofa.rpc.boot.container.RpcFilterContainer;
import com.alipay.sofa.rpc.boot.log.SofaBootRpcLoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class GlobalFilterParser
extends AbstractSimpleBeanDefinitionParser
implements SofaBootTagNameSupport {
    private static final Logger LOGGER = SofaBootRpcLoggerFactory.getLogger(GlobalFilterParser.class);

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String filterId = element.getAttribute("ref");
        String filterClass = element.getAttribute("class");
        if (StringUtils.hasText((String)filterId)) {
            RpcFilterContainer.addFilterId(filterId);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("global filter take effect[" + filterId + "]");
            }
            return;
        }
        if (StringUtils.hasText((String)filterClass)) {
            RpcFilterContainer.addFilterClass(filterClass);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("global filter take effect[" + filterClass + "]");
            }
            return;
        }
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("both the ref attr and class attr is blank, this rpc global filter is invalid");
        }
    }

    public String supportTagName() {
        return "rpc-global-filter";
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected Class<?> getBeanClass(Element element) {
        return Object.class;
    }
}

