/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.config;

import com.alipay.sofa.rpc.boot.config.SofaBootRpcConfigConstants;
import com.alipay.sofa.rpc.boot.config.SofaBootRpcProperties;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

public class ZookeeperConfigurator {
    private String address;
    private final Map<String, String> PARAM_MAP = new HashMap<String, String>();
    private boolean alreadyParse = false;
    private SofaBootRpcProperties sofaBootRpcProperties;

    public ZookeeperConfigurator(SofaBootRpcProperties sofaBootRpcProperties) {
        this.sofaBootRpcProperties = sofaBootRpcProperties;
    }

    String getParamValue(String key) {
        if (StringUtils.hasText((String)key)) {
            return this.PARAM_MAP.get(key);
        }
        return null;
    }

    public String getFile() {
        String file = this.PARAM_MAP.get("file");
        if (!StringUtils.hasText((String)file)) {
            file = SofaBootRpcConfigConstants.REGISTRY_FILE_PATH_DEFAULT;
        }
        return file;
    }

    void parseConfig(String config) {
        if (StringUtils.hasText((String)config) && config.startsWith("zookeeper")) {
            String value = config.substring(12);
            if (!value.contains("?")) {
                this.address = value;
            } else {
                int index = value.lastIndexOf(63);
                this.address = value.substring(0, index);
                String paramString = value.substring(index + 1);
                this.parseParam(paramString);
            }
        }
    }

    public void parseConfig() {
        if (!this.alreadyParse) {
            this.parseConfig(this.sofaBootRpcProperties.getRegistryAddress());
            this.alreadyParse = true;
        }
    }

    private void parseParam(String paramString) {
        if (paramString.contains("&")) {
            String[] paramSplit;
            for (String param : paramSplit = paramString.split("&")) {
                this.parseKeyValue(param);
            }
        } else {
            this.parseKeyValue(paramString);
        }
    }

    private void parseKeyValue(String kv) {
        String[] kvSplit = kv.split("=");
        String key = kvSplit[0];
        String value = kvSplit[1];
        this.PARAM_MAP.put(key, value);
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
}

