/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.runtime.adapter.helper;

import com.alipay.sofa.rpc.boot.common.SofaBootRpcRuntimeException;
import com.alipay.sofa.rpc.boot.container.RegistryConfigContainer;
import com.alipay.sofa.rpc.boot.container.ServerConfigContainer;
import com.alipay.sofa.rpc.boot.runtime.binding.RpcBinding;
import com.alipay.sofa.rpc.boot.runtime.binding.RpcBindingMethodInfo;
import com.alipay.sofa.rpc.boot.runtime.param.RpcBindingParam;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.config.ApplicationConfig;
import com.alipay.sofa.rpc.config.ConfigUniqueNameGenerator;
import com.alipay.sofa.rpc.config.MethodConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.config.UserThreadPoolManager;
import com.alipay.sofa.rpc.filter.Filter;
import com.alipay.sofa.rpc.server.UserThreadPool;
import com.alipay.sofa.runtime.spi.binding.Contract;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ProviderConfigHelper {
    @Autowired
    private ServerConfigContainer serverConfigContainer;
    @Autowired
    private RegistryConfigContainer registryConfigContainer;
    @Value(value="${spring.application.name}")
    private String appName;

    public ProviderConfig getProviderConfig(Contract contract, RpcBinding binding, Object target) throws SofaBootRpcRuntimeException {
        RpcBindingParam param = binding.getRpcBindingParam();
        String id = binding.getBeanId();
        String interfaceId = contract.getInterfaceType().getName();
        Object ref = target;
        String uniqueId = contract.getUniqueId();
        Integer timeout = param.getTimeout();
        Integer weight = param.getWeight();
        Integer warmupTime = param.getWarmUpTime();
        Integer warmupWeight = param.getWarmUpWeight();
        UserThreadPool threadPool = param.getUserThreadPool();
        String serialization = param.getSerialization();
        List<Filter> filters = param.getFilters();
        List<MethodConfig> methodConfigs = this.convertToMethodConfig(param.getMethodInfos());
        ServerConfig serverConfig = this.serverConfigContainer.getServerConfig(binding.getBindingType().getType());
        RegistryConfig registryConfig = this.registryConfigContainer.getRegistryConfig();
        ProviderConfig providerConfig = new ProviderConfig();
        if (StringUtils.hasText((String)this.appName)) {
            providerConfig.setApplication(new ApplicationConfig().setAppName(this.appName));
        }
        if (StringUtils.hasText((String)id)) {
            providerConfig.setId(id);
        }
        if (StringUtils.hasText((String)interfaceId)) {
            providerConfig.setInterfaceId(interfaceId);
        }
        if (ref != null) {
            providerConfig.setRef(ref);
        }
        if (StringUtils.hasText((String)uniqueId)) {
            providerConfig.setUniqueId(uniqueId);
        }
        if (timeout != null) {
            providerConfig.setTimeout(timeout.intValue());
        }
        if (weight != null) {
            providerConfig.setWeight(weight.intValue());
        }
        if (warmupTime != null) {
            providerConfig.setParameter("warmupTime", String.valueOf(warmupTime));
        }
        if (warmupWeight != null) {
            providerConfig.setParameter("warmupWeight", String.valueOf(warmupWeight));
        }
        if (!CollectionUtils.isEmpty(filters)) {
            providerConfig.setFilterRef(filters);
        }
        if (!CollectionUtils.isEmpty(methodConfigs)) {
            providerConfig.setMethods(methodConfigs);
        }
        if (threadPool != null) {
            UserThreadPoolManager.registerUserThread((String)ConfigUniqueNameGenerator.getUniqueName((AbstractInterfaceConfig)providerConfig), (UserThreadPool)threadPool);
        }
        providerConfig.setServer(serverConfig);
        providerConfig.setRegistry(registryConfig);
        String protocol = binding.getBindingType().getType();
        providerConfig.setBootstrap(protocol);
        if (StringUtils.hasText((String)serialization)) {
            providerConfig.setSerialization(serialization);
        }
        providerConfig.setRegister(false);
        return providerConfig;
    }

    private List<MethodConfig> convertToMethodConfig(List<RpcBindingMethodInfo> methodInfos) {
        ArrayList<MethodConfig> methodConfigs = new ArrayList<MethodConfig>();
        if (!CollectionUtils.isEmpty(methodInfos)) {
            for (RpcBindingMethodInfo info : methodInfos) {
                String name = info.getName();
                Integer timeout = info.getTimeout();
                MethodConfig methodConfig = new MethodConfig();
                methodConfig.setName(name);
                if (timeout != null) {
                    methodConfig.setTimeout(timeout);
                }
                methodConfigs.add(methodConfig);
            }
        }
        return methodConfigs;
    }
}

