/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.common.util;

import java.io.IOException;
import java.net.ServerSocket;

public class PortSelectUtils {
    public static final int MIN_PORT_NUMBER = 1100;
    public static final int MAX_PORT_NUMBER = 65535;

    public static synchronized int selectAvailablePort(int defaultPort, int maxLength) {
        for (int i = defaultPort; i < defaultPort + maxLength; ++i) {
            try {
                if (!PortSelectUtils.available(i)) continue;
                return i;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean available(int port) {
        if (port < 1100) throw new IllegalArgumentException("Invalid port: " + port);
        if (port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        try (ServerSocket ss = new ServerSocket(port);){
            ss.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

