/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.model;

import com.alipay.sofa.ark.common.util.ClassLoaderUtils;
import com.alipay.sofa.ark.common.util.ParseUtils;
import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.container.service.ArkServiceContainerHolder;
import com.alipay.sofa.ark.exception.ArkRuntimeException;
import com.alipay.sofa.ark.spi.event.ArkEvent;
import com.alipay.sofa.ark.spi.event.plugin.AfterPluginStartupEvent;
import com.alipay.sofa.ark.spi.event.plugin.AfterPluginStopEvent;
import com.alipay.sofa.ark.spi.event.plugin.BeforePluginStartupEvent;
import com.alipay.sofa.ark.spi.event.plugin.BeforePluginStopEvent;
import com.alipay.sofa.ark.spi.model.Plugin;
import com.alipay.sofa.ark.spi.model.PluginContext;
import com.alipay.sofa.ark.spi.service.PluginActivator;
import com.alipay.sofa.ark.spi.service.event.EventAdminService;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public class PluginModel
implements Plugin {
    private String pluginName;
    private String groupId;
    private String artifactId;
    private String version;
    private int priority = 100;
    public static final String EXPORTMODE_CLASSLOADER = "classLoader";
    public static final String EXPORTMODE_OVERRIDE = "override";
    public static final String EXPORTMODE_UNKNOWN = "unknown";
    private String exportMode = "classLoader";
    private Set<String> exportPackages;
    private Set<String> exportPackageNodes = new HashSet<String>();
    private Set<String> exportPackageStems = new HashSet<String>();
    private Set<String> exportClasses;
    private Set<String> importPackages;
    private Set<String> importPackageNodes = new HashSet<String>();
    private Set<String> importPackageStems = new HashSet<String>();
    private Set<String> importClasses;
    private Set<String> importResources = new HashSet<String>();
    private Set<String> importPrefixResourceStems = new HashSet<String>();
    private Set<String> importSuffixResourceStems = new HashSet<String>();
    private Set<String> exportResources = new HashSet<String>();
    private Set<String> exportPrefixResourceStems = new HashSet<String>();
    private Set<String> exportSuffixResourceStems = new HashSet<String>();
    private String activator;
    private URL[] urls;
    private URL pluginUrl;
    private ClassLoader pluginClassLoader;
    private PluginContext pluginContext;
    private PluginActivator pluginActivator;

    public PluginModel setPluginName(String pluginName) {
        this.pluginName = pluginName;
        return this;
    }

    public PluginModel setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public PluginModel setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public PluginModel setVersion(String version) {
        this.version = version;
        return this;
    }

    public PluginModel setPriority(String priority) {
        this.priority = priority == null ? 100 : Integer.valueOf(priority);
        return this;
    }

    public PluginModel setPluginActivator(String activator) {
        this.activator = activator;
        return this;
    }

    public PluginModel setClassPath(URL[] urls) {
        this.urls = urls;
        return this;
    }

    public PluginModel setExportMode(String exportMode) {
        this.exportMode = exportMode;
        return this;
    }

    public PluginModel setExportPackages(String exportPackages) {
        this.exportPackages = StringUtils.strToSet((String)exportPackages, (String)",");
        ParseUtils.parsePackageNodeAndStem(this.exportPackages, this.exportPackageStems, this.exportPackageNodes);
        return this;
    }

    public PluginModel setExportPackages(String exportPackages, Set<String> exportExtensionPackages) {
        this.exportPackages = StringUtils.strToSet((String)exportPackages, (String)",");
        this.exportPackages.addAll(exportExtensionPackages);
        ParseUtils.parsePackageNodeAndStem(this.exportPackages, this.exportPackageStems, this.exportPackageNodes);
        return this;
    }

    public PluginModel setExportClasses(String exportClasses) {
        this.exportClasses = StringUtils.strToSet((String)exportClasses, (String)",");
        return this;
    }

    public PluginModel setImportPackages(String importPackages) {
        this.importPackages = StringUtils.strToSet((String)importPackages, (String)",");
        ParseUtils.parsePackageNodeAndStem(this.importPackages, this.importPackageStems, this.importPackageNodes);
        return this;
    }

    public PluginModel setImportClasses(String importClasses) {
        this.importClasses = StringUtils.strToSet((String)importClasses, (String)",");
        return this;
    }

    public PluginModel setImportResources(String importResources) {
        ParseUtils.parseResourceAndStem((Set)StringUtils.strToSet((String)importResources, (String)","), this.importPrefixResourceStems, this.importSuffixResourceStems, this.importResources);
        return this;
    }

    public PluginModel setExportResources(String exportResources) {
        ParseUtils.parseResourceAndStem((Set)StringUtils.strToSet((String)exportResources, (String)","), this.exportPrefixResourceStems, this.exportSuffixResourceStems, this.exportResources);
        return this;
    }

    public PluginModel setPluginClassLoader(ClassLoader classLoader) {
        this.pluginClassLoader = classLoader;
        return this;
    }

    public PluginModel setPluginContext(PluginContext context) {
        this.pluginContext = context;
        return this;
    }

    public PluginModel setPluginUrl(URL pluginUrl) {
        this.pluginUrl = pluginUrl;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPluginActivator() {
        return this.activator;
    }

    public URL[] getClassPath() {
        return this.urls;
    }

    public ClassLoader getPluginClassLoader() {
        return this.pluginClassLoader;
    }

    public PluginContext getPluginContext() {
        return this.pluginContext;
    }

    public String getExportMode() {
        if (StringUtils.isEmpty((String)this.exportMode)) {
            return EXPORTMODE_CLASSLOADER;
        }
        return this.exportMode;
    }

    public Set<String> getExportPackages() {
        return this.exportPackages;
    }

    public Set<String> getExportPackageNodes() {
        return this.exportPackageNodes;
    }

    public Set<String> getExportPackageStems() {
        return this.exportPackageStems;
    }

    public Set<String> getExportClasses() {
        return this.exportClasses;
    }

    public Set<String> getImportPackages() {
        return this.importPackages;
    }

    public Set<String> getImportPackageNodes() {
        return this.importPackageNodes;
    }

    public Set<String> getImportPackageStems() {
        return this.importPackageStems;
    }

    public Set<String> getImportClasses() {
        return this.importClasses;
    }

    public Set<String> getImportResources() {
        return this.importResources;
    }

    public Set<String> getImportPrefixResourceStems() {
        return this.importPrefixResourceStems;
    }

    public Set<String> getImportSuffixResourceStems() {
        return this.importSuffixResourceStems;
    }

    public Set<String> getExportResources() {
        return this.exportResources;
    }

    public Set<String> getExportPrefixResourceStems() {
        return this.exportPrefixResourceStems;
    }

    public Set<String> getExportSuffixResourceStems() {
        return this.exportSuffixResourceStems;
    }

    public URL getPluginURL() {
        return this.pluginUrl;
    }

    public void start() throws ArkRuntimeException {
        if (this.activator == null || this.activator.isEmpty()) {
            return;
        }
        EventAdminService eventAdminService = ArkServiceContainerHolder.getContainer().getService(EventAdminService.class);
        ClassLoader oldClassLoader = ClassLoaderUtils.pushContextClassLoader((ClassLoader)this.pluginClassLoader);
        try {
            eventAdminService.sendEvent((ArkEvent)new BeforePluginStartupEvent((Plugin)this));
            this.pluginActivator = (PluginActivator)this.pluginClassLoader.loadClass(this.activator).newInstance();
            this.pluginActivator.start(this.pluginContext);
        }
        catch (Throwable ex) {
            throw new ArkRuntimeException(ex.getMessage(), ex);
        }
        finally {
            eventAdminService.sendEvent((ArkEvent)new AfterPluginStartupEvent((Plugin)this));
            ClassLoaderUtils.popContextClassLoader((ClassLoader)oldClassLoader);
        }
    }

    public void stop() throws ArkRuntimeException {
        EventAdminService eventAdminService = ArkServiceContainerHolder.getContainer().getService(EventAdminService.class);
        eventAdminService.sendEvent((ArkEvent)new BeforePluginStopEvent((Plugin)this));
        try {
            if (this.pluginActivator != null) {
                this.pluginActivator.stop(this.pluginContext);
            }
        }
        catch (Throwable ex) {
            throw new ArkRuntimeException(ex.getMessage(), ex);
        }
        finally {
            eventAdminService.sendEvent((ArkEvent)new AfterPluginStopEvent((Plugin)this));
        }
    }

    public String toString() {
        return "Ark Plugin: " + this.pluginName;
    }
}

