/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.service.classloader;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.container.model.BizModel;
import com.alipay.sofa.ark.container.service.ArkServiceContainerHolder;
import com.alipay.sofa.ark.container.service.classloader.AbstractClasspathClassLoader;
import com.alipay.sofa.ark.exception.ArkLoaderException;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.service.biz.BizManagerService;
import com.alipay.sofa.ark.spi.service.classloader.ClassLoaderHook;
import com.alipay.sofa.ark.spi.service.extension.ArkServiceLoader;
import java.io.IOException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicBoolean;

public class BizClassLoader
extends AbstractClasspathClassLoader {
    private String bizIdentity;
    private BizManagerService bizManagerService = ArkServiceContainerHolder.getContainer().getService(BizManagerService.class);
    private ClassLoaderHook<Biz> bizClassLoaderHook;
    private AtomicBoolean isHookLoaded = new AtomicBoolean(false);
    private AtomicBoolean skipLoadHook = new AtomicBoolean(false);
    private final Object lock = new Object();
    private BizModel bizModel;

    public void setBizModel(BizModel bizModel) {
        this.bizModel = bizModel;
    }

    public BizModel getBizModel() {
        return this.bizModel;
    }

    public BizClassLoader(String bizIdentity, URL[] urls) {
        super(urls);
        this.bizIdentity = bizIdentity;
    }

    public BizClassLoader(String bizIdentity, URL[] urls, boolean exploded) {
        this(bizIdentity, urls);
        this.exploded = exploded;
    }

    public Class<?> publicDefineClass(String name, byte[] b, ProtectionDomain protectionDomain) {
        return this.defineClass(name, b, 0, b.length, protectionDomain);
    }

    @Override
    protected Class<?> loadClassInternal(String name, boolean resolve) throws ArkLoaderException {
        Class<?> clazz = null;
        if (this.classloaderService.isSunReflectClass(name)) {
            throw new ArkLoaderException(String.format("[ArkBiz Loader] %s : can not load class: %s, this class can only be loaded by sun.reflect.DelegatingClassLoader", this.bizIdentity, name));
        }
        if (clazz == null) {
            clazz = this.findLoadedClass(name);
        }
        if (clazz == null) {
            clazz = this.resolveJDKClass(name);
        }
        if (clazz == null) {
            clazz = this.resolveArkClass(name);
        }
        if (clazz == null) {
            clazz = this.preLoadClass(name);
        }
        if (clazz == null) {
            clazz = this.resolveExportClass(name);
        }
        if (clazz == null) {
            clazz = this.resolveLocalClass(name);
        }
        if (clazz == null) {
            clazz = this.resolveJavaAgentClass(name);
        }
        if (clazz == null) {
            clazz = this.postLoadClass(name);
        }
        if (clazz != null) {
            if (resolve) {
                super.resolveClass(clazz);
            }
            return clazz;
        }
        throw new ArkLoaderException(String.format("[ArkBiz Loader] %s : can not load class: %s", this.bizIdentity, name));
    }

    @Override
    boolean shouldFindExportedClass(String className) {
        return !this.classloaderService.isDeniedImportClass(this.bizIdentity, className);
    }

    @Override
    boolean shouldFindExportedResource(String resourceName) {
        return !this.classloaderService.isDeniedImportResource(this.bizIdentity, resourceName);
    }

    public boolean checkDeclaredMode() {
        BizModel biz = this.getBizModel();
        if (biz == null) {
            return false;
        }
        return biz.isDeclaredMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBizClassLoaderHook() {
        if (!this.skipLoadHook.get()) {
            Object object = this.lock;
            synchronized (object) {
                if (this.isHookLoaded.compareAndSet(false, true)) {
                    this.bizClassLoaderHook = (ClassLoaderHook)ArkServiceLoader.loadExtensionFromArkBiz(ClassLoaderHook.class, (String)"biz-classloader-hook", (String)this.bizIdentity);
                    Biz masterBiz = ArkClient.getMasterBiz();
                    if (this.bizClassLoaderHook == null && masterBiz != null && !masterBiz.getIdentity().equals(this.bizIdentity)) {
                        ClassLoader masterClassLoader = masterBiz.getBizClassLoader();
                        String defaultBizClassloaderHook = System.getProperty("com.alipay.sofa.ark.biz.classloader.hook.dir");
                        if (!StringUtils.isEmpty((String)defaultBizClassloaderHook)) {
                            try {
                                this.bizClassLoaderHook = (ClassLoaderHook)masterClassLoader.loadClass(defaultBizClassloaderHook).newInstance();
                            }
                            catch (Exception e) {
                                throw new RuntimeException(String.format("can not find master classloader hook: %s", defaultBizClassloaderHook), e);
                            }
                        }
                    }
                    this.skipLoadHook.set(true);
                }
            }
        }
    }

    @Override
    protected Class<?> preLoadClass(String className) throws ArkLoaderException {
        try {
            this.loadBizClassLoaderHook();
            return this.bizClassLoaderHook == null ? null : this.bizClassLoaderHook.preFindClass(className, this.classloaderService, (Object)this.bizManagerService.getBizByIdentity(this.bizIdentity));
        }
        catch (Throwable throwable) {
            throw new ArkLoaderException(String.format("Pre find class %s occurs an error via biz ClassLoaderHook: %s.", className, this.bizClassLoaderHook), throwable);
        }
    }

    @Override
    protected Class<?> postLoadClass(String className) throws ArkLoaderException {
        try {
            this.loadBizClassLoaderHook();
            return this.bizClassLoaderHook == null ? null : this.bizClassLoaderHook.postFindClass(className, this.classloaderService, (Object)this.bizManagerService.getBizByIdentity(this.bizIdentity));
        }
        catch (Throwable throwable) {
            throw new ArkLoaderException(String.format("Post find class %s occurs an error via biz ClassLoaderHook: %s.", className, this.bizClassLoaderHook), throwable);
        }
    }

    @Override
    protected URL preFindResource(String resourceName) {
        this.loadBizClassLoaderHook();
        return this.bizClassLoaderHook == null ? null : this.bizClassLoaderHook.preFindResource(resourceName, this.classloaderService, (Object)this.bizManagerService.getBizByIdentity(this.bizIdentity));
    }

    @Override
    protected URL postFindResource(String resourceName) {
        this.loadBizClassLoaderHook();
        return this.bizClassLoaderHook == null ? null : this.bizClassLoaderHook.postFindResource(resourceName, this.classloaderService, (Object)this.bizManagerService.getBizByIdentity(this.bizIdentity));
    }

    @Override
    protected Enumeration<URL> preFindResources(String resourceName) throws IOException {
        this.loadBizClassLoaderHook();
        return this.bizClassLoaderHook == null ? null : this.bizClassLoaderHook.preFindResources(resourceName, this.classloaderService, (Object)this.bizManagerService.getBizByIdentity(this.bizIdentity));
    }

    @Override
    protected Enumeration<URL> postFindResources(String resourceName) throws IOException {
        this.loadBizClassLoaderHook();
        return this.bizClassLoaderHook == null ? null : this.bizClassLoaderHook.postFindResources(resourceName, this.classloaderService, (Object)this.bizManagerService.getBizByIdentity(this.bizIdentity));
    }

    public String getBizIdentity() {
        return this.bizIdentity;
    }

    public void setBizIdentity(String bizIdentity) {
        this.bizIdentity = bizIdentity;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

