/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.service.plugin;

import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.spi.model.Plugin;
import com.alipay.sofa.ark.spi.service.ArkInject;
import com.alipay.sofa.ark.spi.service.plugin.PluginManagerService;
import com.alipay.sofa.ark.spi.service.session.CommandProvider;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class PluginCommandProvider
implements CommandProvider {
    @ArkInject
    private PluginManagerService pluginManagerService;
    private static final String HELP_MESSAGE = "Plugin Command Tips:\n  USAGE: plugin [option...] [pluginName...]\n  SAMPLE: plugin -m plugin-A plugin-B\n  -h  Shows the help message.\n  -a  Shows all plugin name.\n  -m  Shows the meta info of specified pluginName.\n  -s  Shows the service info of specified pluginName.\n  -d  Shows the detail info of specified pluginName.\n";

    public String getHelp() {
        return HELP_MESSAGE;
    }

    public String handleCommand(String command) {
        return new PluginCommand(command).process();
    }

    public boolean validate(String command) {
        return new PluginCommand(command).isValidate();
    }

    class PluginCommand {
        private boolean isValidate;
        private Set<Character> options = new HashSet<Character>();
        private Set<String> parameters = new HashSet<String>();

        PluginCommand(String command) {
            if (StringUtils.isEmpty((String)command)) {
                this.isValidate = false;
                return;
            }
            String[] syntax = command.trim().split("\\s+");
            if (!"plugin".equals(syntax[0])) {
                this.isValidate = false;
                return;
            }
            int pluginNameIndex = syntax.length;
            for (int i = 1; i < syntax.length; ++i) {
                if (!syntax[i].startsWith("-")) {
                    pluginNameIndex = i;
                    break;
                }
                if (syntax[i].startsWith("-") && syntax[i].length() == 1) {
                    this.isValidate = false;
                    return;
                }
                for (int j = 1; j < syntax[i].length(); ++j) {
                    this.options.add(Character.valueOf(syntax[i].charAt(j)));
                }
            }
            block5: for (Character option : this.options) {
                switch (option.charValue()) {
                    case 'a': 
                    case 'd': 
                    case 'h': 
                    case 'm': 
                    case 's': {
                        continue block5;
                    }
                }
                this.isValidate = false;
                return;
            }
            if ((this.options.contains(Character.valueOf('h')) || this.options.contains(Character.valueOf('a'))) && this.options.size() > 1) {
                this.isValidate = false;
                return;
            }
            while (pluginNameIndex < syntax.length) {
                this.parameters.add(syntax[pluginNameIndex++]);
            }
            if ((this.options.contains(Character.valueOf('h')) || this.options.contains(Character.valueOf('a'))) && this.parameters.size() > 0) {
                this.isValidate = false;
                return;
            }
            if (this.options.isEmpty()) {
                this.isValidate = false;
                return;
            }
            if (!this.options.contains(Character.valueOf('h')) && !this.options.contains(Character.valueOf('a')) && !this.options.isEmpty() && this.parameters.isEmpty()) {
                this.isValidate = false;
                return;
            }
            this.isValidate = true;
        }

        boolean isValidate() {
            return this.isValidate;
        }

        String process() {
            if (!this.isValidate) {
                return "Error command format. Pls type 'plugin -h' to get help message\n";
            }
            StringBuilder sb = new StringBuilder(512);
            if (this.options.contains(Character.valueOf('h'))) {
                sb.append(PluginCommandProvider.this.getHelp());
            } else {
                if (this.options.contains(Character.valueOf('a'))) {
                    return this.pluginList();
                }
                Set candidates = PluginCommandProvider.this.pluginManagerService.getAllPluginNames();
                boolean matched = false;
                for (String pattern : this.parameters) {
                    for (String candidate : candidates) {
                        if (!Pattern.matches(pattern, candidate)) continue;
                        matched = true;
                        sb.append(this.pluginInfo(candidate));
                    }
                }
                if (!matched) {
                    sb.append("no matched plugin candidates.").append("\n");
                }
            }
            return sb.toString();
        }

        String pluginList() {
            Set pluginNames = PluginCommandProvider.this.pluginManagerService.getAllPluginNames();
            StringBuilder sb = new StringBuilder(128);
            if (pluginNames.isEmpty()) {
                sb.append("no plugins.").append("\n");
            } else {
                for (String pluginName : pluginNames) {
                    sb.append(pluginName).append("\n");
                }
            }
            sb.append("plugin count = ").append(pluginNames.size()).append("\n");
            return sb.toString();
        }

        String pluginInfo(String pluginName) {
            Plugin plugin = PluginCommandProvider.this.pluginManagerService.getPluginByName(pluginName);
            StringBuilder sb = new StringBuilder(256);
            if (this.options.contains(Character.valueOf('m'))) {
                sb.append("PluginName:       ").append(pluginName).append("\n");
                sb.append("Version:          ").append(plugin.getVersion()).append("\n");
                sb.append("Priority:         ").append(plugin.getPriority()).append("\n");
                sb.append("Activator:        ").append(plugin.getPluginActivator()).append("\n");
                sb.append("Export Packages:  ").append(StringUtils.setToStr((Set)plugin.getExportPackages(), (String)",", (String)"\\")).append("\n");
                sb.append("Import Packages:  ").append(StringUtils.setToStr((Set)plugin.getImportPackages(), (String)",", (String)"\\")).append("\n");
                sb.append("Export Classes:   ").append(StringUtils.setToStr((Set)plugin.getExportClasses(), (String)",", (String)"\\")).append("\n");
                sb.append("Import Classes:   ").append(StringUtils.setToStr((Set)plugin.getImportClasses(), (String)",", (String)"\\")).append("\n");
                sb.append("Export Resources: ").append(StringUtils.setToStr((Set)plugin.getExportResources(), (String)",", (String)"\\")).append("\n");
                sb.append("Import Resources: ").append(StringUtils.setToStr((Set)plugin.getImportResources(), (String)",", (String)"\\")).append("\n");
            }
            if (this.options.contains(Character.valueOf('s'))) {
                // empty if block
            }
            if (this.options.contains(Character.valueOf('d'))) {
                sb.append("GroupId:     ").append(plugin.getGroupId()).append("\n");
                sb.append("ArtifactId:  ").append(plugin.getArtifactId()).append("\n");
                sb.append("Version:     ").append(plugin.getVersion()).append("\n");
                sb.append("URL:         ").append(plugin.getPluginURL()).append("\n");
                sb.append("ClassLoader: ").append(plugin.getPluginClassLoader()).append("\n");
                sb.append("ClassPath:   ").append(this.join(plugin.getClassPath(), ",")).append("\n");
            }
            sb.append("\n");
            return sb.toString();
        }

        String join(URL[] urls, String separator) {
            HashSet<String> set = new HashSet<String>();
            if (urls != null) {
                for (URL url : urls) {
                    set.add(url.getPath());
                }
            }
            return StringUtils.setToStr(set, (String)separator, (String)"\\");
        }
    }
}

