/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.session.handler;

import com.alipay.sofa.ark.common.thread.CommonThreadPool;
import com.alipay.sofa.ark.common.thread.ThreadPoolManager;
import com.alipay.sofa.ark.common.util.StringUtils;
import com.alipay.sofa.ark.container.service.ArkServiceContainerHolder;
import com.alipay.sofa.ark.spi.constant.Constants;
import com.alipay.sofa.ark.spi.registry.ServiceReference;
import com.alipay.sofa.ark.spi.service.registry.RegistryService;
import com.alipay.sofa.ark.spi.service.session.CommandProvider;
import java.util.List;

public class ArkCommandHandler {
    private RegistryService registryService = ArkServiceContainerHolder.getContainer().getService(RegistryService.class);

    private static void init() {
        CommonThreadPool commandPool = new CommonThreadPool().setAllowCoreThreadTimeOut(true).setThreadPoolName("telnet-command").setDaemon(true);
        ThreadPoolManager.registerThreadPool((String)"telnet-command", (CommonThreadPool)commandPool);
    }

    public String handleCommand(String cmdLine) {
        if (StringUtils.isEmpty((String)cmdLine)) {
            return "";
        }
        List commandProviders = this.registryService.referenceServices(CommandProvider.class, null);
        for (ServiceReference commandService : commandProviders) {
            CommandProvider commandProvider = (CommandProvider)commandService.getService();
            if (!commandProvider.validate(cmdLine)) continue;
            return commandProvider.handleCommand(cmdLine);
        }
        return this.helpMessage(commandProviders);
    }

    public String helpMessage(List<ServiceReference<CommandProvider>> commandProviders) {
        StringBuilder sb = new StringBuilder();
        for (ServiceReference<CommandProvider> commandService : commandProviders) {
            CommandProvider commandProvider = (CommandProvider)commandService.getService();
            sb.append(commandProvider.getHelp());
        }
        return sb.toString();
    }

    public String promptMessage() {
        return "sofa-ark>";
    }

    public String responseMessage(String cmd) {
        String commandResult = this.handleCommand(cmd);
        if (StringUtils.isEmpty((String)(commandResult = commandResult.replace("\n", Constants.TELNET_STRING_END)))) {
            commandResult = Constants.TELNET_STRING_END;
        } else if (!commandResult.endsWith(Constants.TELNET_STRING_END)) {
            commandResult = commandResult + Constants.TELNET_STRING_END + Constants.TELNET_STRING_END;
        } else if (!commandResult.endsWith(Constants.TELNET_STRING_END.concat(Constants.TELNET_STRING_END))) {
            commandResult = commandResult + Constants.TELNET_STRING_END;
        }
        commandResult = commandResult + this.promptMessage();
        return commandResult;
    }

    static {
        ArkCommandHandler.init();
    }
}

