/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.test;

import com.alipay.sofa.ark.container.model.BizModel;
import com.alipay.sofa.ark.container.service.ArkServiceContainerHolder;
import com.alipay.sofa.ark.container.service.classloader.BizClassLoader;
import com.alipay.sofa.ark.exception.ArkRuntimeException;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.model.BizState;
import com.alipay.sofa.ark.spi.service.biz.BizManagerService;
import java.net.URL;

public class NoneDelegateTestClassLoader
extends BizClassLoader {
    public NoneDelegateTestClassLoader(String bizIdentity, URL[] urls) {
        super(bizIdentity, urls);
        BizManagerService bizManagerService = ArkServiceContainerHolder.getContainer().getService(BizManagerService.class);
        Biz testBiz = this.createTestBiz(bizIdentity);
        bizManagerService.registerBiz(testBiz);
        ((BizModel)testBiz).setBizState(BizState.ACTIVATED);
    }

    private Biz createTestBiz(String bizIdentity) {
        String[] bizNameAndVersion = bizIdentity.split(":");
        if (bizNameAndVersion.length != 2) {
            throw new ArkRuntimeException("error bizIdentity format.");
        }
        BizManagerService bizManagerService = ArkServiceContainerHolder.getContainer().getService(BizManagerService.class);
        BizModel testBiz = new BizModel().setBizName(bizNameAndVersion[0]).setBizVersion(bizNameAndVersion[1]).setClassLoader(this).setDenyImportPackages("").setDenyImportClasses("").setDenyImportResources("").setBizState(BizState.RESOLVED);
        bizManagerService.registerBiz((Biz)testBiz);
        return testBiz;
    }
}

